/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item.ammo_behaviour;

import com.milamber_brass.brass_armory.init.BrassArmoryAmmoBehaviours;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractAmmoBehaviour {
    public final int stackShrink;

    public AbstractAmmoBehaviour(int stackShrink) {
        this.stackShrink = stackShrink;
    }

    @Nonnull
    public static Optional<AbstractAmmoBehaviour> getStackBehaviour(ItemStack stack) {
        return BrassArmoryAmmoBehaviours.ammoBehaviours.stream().filter(b -> b.getAmmoItems().test(stack)).findFirst();
    }

    public static boolean itemHasAmmoBehaviour(Item item) {
        return BrassArmoryAmmoBehaviours.ammoBehaviours.stream().anyMatch(b -> b.getAmmoItems().test(item.m_7968_()));
    }

    public abstract boolean onShoot(Level var1, LivingEntity var2, ItemStack var3, ItemStack var4, double var5, float var7, float var8);

    @ParametersAreNonnullByDefault
    public void onLoad(Level level, LivingEntity livingEntity, ItemStack weaponStack, ItemStack ammoStack) {
    }

    @Nonnull
    public abstract Predicate<ItemStack> getAmmoItems();
}

