/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.mixin;

import com.milamber_brass.brass_armory.container.GunContainer;
import com.milamber_brass.brass_armory.item.MaceItem;
import com.milamber_brass.brass_armory.item.abstracts.AbstractGunItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public abstract class HumanoidModelMixin {
    @Shadow
    @Final
    public ModelPart f_102812_;
    @Shadow
    @Final
    public ModelPart f_102811_;
    @Shadow
    @Final
    public ModelPart f_102808_;
    @Shadow
    public HumanoidModel.ArmPose f_102816_;
    @Shadow
    public HumanoidModel.ArmPose f_102815_;
    @Unique
    float savedLeftRot;
    @Unique
    float savedRightRot;

    @ParametersAreNonnullByDefault
    @Inject(method={"setupAnim*"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/HumanoidArm;RIGHT:Lnet/minecraft/world/entity/HumanoidArm;", shift=At.Shift.AFTER, ordinal=0)}, remap=true)
    private void saveRotsMixin(LivingEntity living, float p_102867_, float p_102868_, float p_102869_, float p_102870_, float p_102871_, CallbackInfo ci) {
        this.savedLeftRot = this.f_102812_.f_104203_;
        this.savedRightRot = this.f_102811_.f_104203_;
    }

    @ParametersAreNonnullByDefault
    @Inject(method={"setupAnim*"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/HumanoidModel;setupAttackAnimation(Lnet/minecraft/world/entity/LivingEntity;F)V", shift=At.Shift.AFTER)}, remap=true)
    private void gunRePose(LivingEntity living, float p_102867_, float p_102868_, float p_102869_, float p_102870_, float p_102871_, CallbackInfo ci) {
        if (living.m_6117_()) {
            if (living.m_21205_().m_41720_() instanceof MaceItem && living.m_21206_().m_41720_() instanceof MaceItem) {
                this.f_102811_.f_104203_ = this.savedRightRot * 0.5f - (float)Math.PI;
                this.f_102811_.f_104204_ = 0.0f;
                this.f_102812_.f_104203_ = this.savedLeftRot * 0.5f - (float)Math.PI;
                this.f_102812_.f_104204_ = 0.0f;
            } else if (living.m_21211_().m_41720_() instanceof AbstractGunItem) {
                HumanoidArm mainArm = living.m_5737_();
                InteractionHand hand = living.m_7655_();
                boolean rightArm = mainArm == HumanoidArm.RIGHT && hand == InteractionHand.MAIN_HAND || mainArm == HumanoidArm.LEFT && hand == InteractionHand.OFF_HAND;
                this.holdLoadingGun(rightArm, AbstractGunItem.getLoadProgress(living.m_21211_()), true);
            }
        } else {
            Item player;
            AbstractGunItem gunItem;
            Item hand = living.m_21205_().m_41720_();
            if (hand instanceof AbstractGunItem) {
                gunItem = (AbstractGunItem)hand;
                switch (AbstractGunItem.getLoad(living.m_21205_())) {
                    case 0: {
                        if (!(living instanceof Player)) break;
                        player = (Player)living;
                        if (!(player.f_36096_ instanceof GunContainer)) break;
                        this.holdLoadingGun(living.m_5737_() == HumanoidArm.RIGHT, AbstractGunItem.getLoadProgress(living.m_21211_()), false);
                        break;
                    }
                    case 2: {
                        if (!gunItem.isOneHanded()) break;
                        this.holdLoadedGun(living.m_5737_() != HumanoidArm.RIGHT, true, !living.m_21206_().m_41619_());
                    }
                }
            }
            if ((player = living.m_21206_().m_41720_()) instanceof AbstractGunItem) {
                gunItem = (AbstractGunItem)player;
                switch (AbstractGunItem.getLoad(living.m_21206_())) {
                    case 0: {
                        if (!(living instanceof Player)) break;
                        player = (Player)living;
                        if (!(player.f_36096_ instanceof GunContainer)) break;
                        this.holdLoadingGun(living.m_5737_() == HumanoidArm.LEFT, AbstractGunItem.getLoadProgress(living.m_21211_()), false);
                        break;
                    }
                    case 2: {
                        if (!gunItem.isOneHanded()) break;
                        this.holdLoadedGun(living.m_5737_() != HumanoidArm.LEFT, false, !living.m_21205_().m_41619_());
                    }
                }
            }
        }
    }

    @Unique
    private void holdLoadingGun(boolean rightArm, float loadProgress, boolean using) {
        ModelPart holdArm = rightArm ? this.f_102811_ : this.f_102812_;
        holdArm.f_104204_ = rightArm ? -0.8f : 0.8f;
        holdArm.f_104203_ = -0.97079635f;
        ModelPart loadArm = rightArm ? this.f_102812_ : this.f_102811_;
        loadArm.f_104203_ = holdArm.f_104203_;
        float maxLoad = 20.0f;
        float clampLoad = Mth.m_14036_((float)loadProgress, (float)0.0f, (float)maxLoad);
        float finalLoad = clampLoad / maxLoad;
        if (!using) {
            finalLoad = (float)((double)finalLoad + 0.43);
        }
        loadArm.f_104204_ = Mth.m_14179_((float)finalLoad, (float)0.4f, (float)0.85f) * (float)(rightArm ? 1 : -1);
        loadArm.f_104203_ = Mth.m_14179_((float)finalLoad, (float)loadArm.f_104203_, (float)-1.5707964f);
    }

    @Unique
    private void holdLoadedGun(boolean leftHand, boolean mainHand, boolean otherHandHasItem) {
        if (leftHand) {
            if (!mainHand && this.f_102816_.m_102897_()) {
                return;
            }
            this.f_102812_.f_104204_ = 0.1f + this.f_102808_.f_104204_;
            this.f_102812_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
            if (mainHand) {
                this.f_102811_.f_104203_ = this.savedRightRot;
                if (otherHandHasItem) {
                    this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - 0.31415927f;
                }
                this.f_102811_.f_104204_ = 0.0f;
            }
        } else {
            if (!mainHand && this.f_102815_.m_102897_()) {
                return;
            }
            this.f_102811_.f_104204_ = -0.1f + this.f_102808_.f_104204_;
            this.f_102811_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
            if (mainHand) {
                this.f_102812_.f_104203_ = this.savedLeftRot;
                if (otherHandHasItem) {
                    this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - 0.31415927f;
                }
                this.f_102812_.f_104204_ = 0.0f;
            }
        }
    }
}

