/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.entity.ai.goal.AttackRevengeTargetGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.EatFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FindFavouriteFoodGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FirePanicGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.FollowPotentialCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.LookAtCustomerGoal;
import com.mrcrayfish.goblintraders.entity.ai.goal.TradeWithPlayerGoal;
import com.mrcrayfish.goblintraders.init.ModSounds;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractGoblinEntity
extends TraderCreatureEntity
implements Npc {
    public static final EntityDataAccessor<Boolean> STUNNED = SynchedEntityData.m_135353_(AbstractGoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> STUN_ROTATION = SynchedEntityData.m_135353_(AbstractGoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Nullable
    private Player customer;
    private Set<UUID> tradedCustomers = new HashSet<UUID>();
    @Nullable
    private MerchantOffers offers;
    private int stunDelay;
    private int despawnDelay;
    private int fallCounter;
    private int restockDelay;

    protected AbstractGoblinEntity(EntityType<? extends TraderCreatureEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FirePanicGoal(this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new TradeWithPlayerGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtCustomerGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new AttackRevengeTargetGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new FollowPotentialCustomerGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new FindFavouriteFoodGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 0.4, Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.getFavouriteFood()}), false));
        this.f_21345_.m_25352_(8, (Goal)new EatFavouriteFoodGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(9, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(10, (Goal)new InteractGoal((Mob)this, Player.class, 4.0f, 1.0f));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    protected void m_8022_() {
        super.m_8022_();
        if (this.isStunned()) {
            this.f_21345_.m_25360_(Goal.Flag.MOVE, true);
            this.f_21345_.m_25360_(Goal.Flag.JUMP, true);
            this.f_21345_.m_25360_(Goal.Flag.LOOK, true);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STUNNED, (Object)false);
        this.f_19804_.m_135372_(STUN_ROTATION, (Object)Float.valueOf(0.0f));
    }

    public abstract ResourceLocation getTexture();

    public int getFallCounter() {
        return this.fallCounter;
    }

    public ItemStack m_5584_(Level level, ItemStack stack) {
        if (stack.m_41720_() == this.getFavouriteFood().m_41720_() && stack.m_41720_().m_41473_() != null) {
            this.m_21153_(this.m_21223_() + (float)stack.m_41720_().m_41473_().m_38744_());
        }
        return super.m_5584_(level, stack);
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_21203_();
        if (this.stunDelay > 0) {
            --this.stunDelay;
            if (this.stunDelay == 0) {
                this.f_19804_.m_135381_(STUNNED, (Object)false);
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.ENTITY_GOBLIN_TRADER_ANNOYED_GRUNT.get(), SoundSource.NEUTRAL, 1.0f, 0.9f + this.m_21187_().nextFloat() * 0.2f);
            }
        }
        if (!(this.f_19853_.m_5776_() || ((Boolean)Config.COMMON.preventDespawnIfNamed.get()).booleanValue() && this.m_21532_())) {
            this.handleDespawn();
        } else if (((Boolean)this.f_19804_.m_135370_(STUNNED)).booleanValue()) {
            if (this.fallCounter < 10) {
                ++this.fallCounter;
            }
        } else {
            this.fallCounter = 0;
        }
        if (!this.f_19853_.m_5776_() && this.getMaxRestockDelay() != -1 && ++this.restockDelay >= this.getMaxRestockDelay()) {
            this.m_6616_().forEach(MerchantOffer::m_45372_);
            this.restockDelay = 0;
        }
    }

    public void m_7189_(@Nullable Player player) {
        this.customer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    protected abstract void populateTradeData();

    protected void addTrades(MerchantOffers offers, @Nullable List<VillagerTrades.ItemListing> trades, int max, boolean shuffle) {
        if (trades == null) {
            return;
        }
        List randomIndexes = IntStream.range(0, trades.size()).boxed().collect(Collectors.toList());
        if (shuffle) {
            Collections.shuffle(randomIndexes);
        }
        randomIndexes = randomIndexes.subList(0, Math.min(trades.size(), max));
        for (Integer index : randomIndexes) {
            VillagerTrades.ItemListing trade = trades.get(index);
            MerchantOffer offer = trade.m_5670_((Entity)this, this.m_21187_());
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public void m_6255_(@Nullable MerchantOffers offers) {
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
        if (this.customer != null) {
            this.tradedCustomers.add(this.customer.m_142081_());
        }
        if (this.f_19853_ instanceof ServerLevel) {
            ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.f_19853_), (Vec3)this.m_20318_(1.0f), (int)offer.m_45379_());
        }
    }

    public void m_7713_(ItemStack stack) {
    }

    public Level m_183503_() {
        return this.f_19853_;
    }

    public boolean m_183595_() {
        return this.m_183503_().f_46443_;
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int xpIn) {
    }

    public boolean m_7826_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12509_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == Items.f_42656_) {
            heldItem.m_41647_(player, (LivingEntity)this, hand);
            return InteractionResult.SUCCESS;
        }
        if (!(!this.m_6084_() || this.hasCustomer() || this.m_6162_() || !this.m_5825_() && this.m_6060_() || this.isStunned())) {
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
            }
            if (!(this.f_19853_.m_5776_() || this.m_142581_() != null && this.m_142581_() == player)) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    protected void m_21137_(ItemStack stack, int count) {
        if (!stack.m_41619_() && this.m_6117_()) {
            if (stack.m_41780_() == UseAnim.DRINK) {
                this.m_5496_(this.m_7838_(stack), 0.5f, this.f_19853_.m_5822_().nextFloat() * 0.1f + 0.9f);
            }
            if (stack.m_41780_() == UseAnim.EAT) {
                this.spawnFoodParticles(stack, count);
                this.m_5496_(this.m_7866_(stack), 0.5f + 0.5f * (float)this.m_21187_().nextInt(2), (this.m_21187_().nextFloat() - this.m_21187_().nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected void spawnFoodParticles(ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 frontPosition = Vec3.m_82498_((float)0.0f, (float)this.f_20883_).m_82490_(0.25);
            frontPosition = frontPosition.m_82520_(0.0, 0.35, 0.0);
            frontPosition = frontPosition.m_82549_(this.m_20182_());
            Vec3 motion = new Vec3(this.m_21187_().nextDouble() * 0.2 - 0.1, 0.1, this.m_21187_().nextDouble() * 0.2 - 0.1);
            if (this.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), frontPosition.f_82479_, frontPosition.f_82480_, frontPosition.f_82481_, 1, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_, 0.0);
                continue;
            }
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), frontPosition.f_82479_, frontPosition.f_82480_, frontPosition.f_82481_, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_);
        }
    }

    public boolean isPreviousCustomer(Player player) {
        return this.tradedCustomers.contains(player.m_142081_());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean attacked = super.m_6469_(source, amount);
        if (attacked && source.m_7639_() instanceof Player) {
            this.m_21573_().m_26573_();
            this.f_19804_.m_135381_(STUNNED, (Object)true);
            this.f_19804_.m_135381_(STUN_ROTATION, (Object)Float.valueOf(this.getStunRotation(source.m_7639_())));
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            this.stunDelay = 20;
        }
        return attacked;
    }

    private float getStunRotation(@Nullable Entity entity) {
        return entity != null ? entity.m_146908_() : 0.0f;
    }

    public int getStunDelay() {
        return this.stunDelay;
    }

    public void setDespawnDelay(int despawnDelay) {
        this.despawnDelay = despawnDelay;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Offers", 10)) {
            this.offers = new MerchantOffers(compound.m_128469_("Offers"));
        }
        if (compound.m_128425_("DespawnDelay", 3)) {
            this.despawnDelay = compound.m_128451_("DespawnDelay");
        }
        if (compound.m_128425_("RestockDelay", 3)) {
            this.restockDelay = compound.m_128451_("RestockDelay");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        MerchantOffers offers = this.m_6616_();
        if (!offers.isEmpty()) {
            compound.m_128365_("Offers", (Tag)offers.m_45388_());
        }
        compound.m_128405_("DespawnDelay", this.despawnDelay);
        compound.m_128405_("RestockDelay", this.restockDelay);
    }

    private void handleDespawn() {
        if (this.despawnDelay > 0 && !this.hasCustomer() && --this.despawnDelay == 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.ENTITY_GOBLIN_TRADER_IDLE_GRUNT.get();
    }

    public abstract ItemStack getFavouriteFood();

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.7);
    }

    public boolean isStunned() {
        return (Boolean)this.f_19804_.m_135370_(STUNNED);
    }

    public float getStunRotation() {
        return ((Float)this.f_19804_.m_135370_(STUN_ROTATION)).floatValue();
    }

    protected abstract int getMaxRestockDelay();

    public abstract boolean canAttackBack();

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }
}

