/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.world.spawner;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.init.ModEntities;
import com.mrcrayfish.goblintraders.world.spawner.GoblinTraderSpawner;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="goblintraders")
public class SpawnHandler {
    private static Map<ResourceLocation, GoblinTraderSpawner> spawners = new HashMap<ResourceLocation, GoblinTraderSpawner>();

    @SubscribeEvent
    public static void onWorldLoad(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        spawners.put(DimensionType.f_63845_.m_135782_(), new GoblinTraderSpawner(server, "GoblinTrader", (EntityType<? extends AbstractGoblinEntity>)((EntityType)ModEntities.GOBLIN_TRADER.get()), Config.COMMON.goblinTrader));
        spawners.put(DimensionType.f_63846_.m_135782_(), new GoblinTraderSpawner(server, "VeinGoblinTrader", (EntityType<? extends AbstractGoblinEntity>)((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get()), Config.COMMON.veinGoblinTrader));
    }

    @SubscribeEvent
    public static void onServerStart(ServerStoppedEvent event) {
        spawners.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        GoblinTraderSpawner spawner = spawners.get(event.world.m_46472_().m_135782_());
        if (spawner != null) {
            spawner.tick(event.world);
        }
    }
}

