/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import quek.undergarden.client.UndergardenClient;
import quek.undergarden.data.UGAdvancements;
import quek.undergarden.data.UGBlockStates;
import quek.undergarden.data.UGBlockTags;
import quek.undergarden.data.UGEntityTags;
import quek.undergarden.data.UGFluidTags;
import quek.undergarden.data.UGItemModels;
import quek.undergarden.data.UGItemTags;
import quek.undergarden.data.UGLang;
import quek.undergarden.data.UGLootTables;
import quek.undergarden.data.UGRecipes;
import quek.undergarden.data.UGSoundDefinitions;
import quek.undergarden.entity.projectile.BlisterbombEntity;
import quek.undergarden.entity.projectile.GooBallEntity;
import quek.undergarden.entity.projectile.RottenBlisterberryEntity;
import quek.undergarden.entity.projectile.SlingshotAmmoEntity;
import quek.undergarden.registry.UGBiomes;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGCarvers;
import quek.undergarden.registry.UGConfiguredCarvers;
import quek.undergarden.registry.UGConfiguredFeatures;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGFeatures;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGPlacedFeatures;
import quek.undergarden.registry.UGPointOfInterests;
import quek.undergarden.registry.UGPotions;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGStructures;
import quek.undergarden.registry.UGTreeDecoratorTypes;
import quek.undergarden.registry.UGTrunkPlacerTypes;

@Mod(value="undergarden")
public class Undergarden {
    public static final String MODID = "undergarden";
    public static final Logger LOGGER = LogManager.getLogger();

    public Undergarden() {
        DeferredRegister[] registers;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::gatherData);
        for (DeferredRegister register : registers = new DeferredRegister[]{UGBiomes.BIOMES, UGBlocks.BLOCKS, UGCarvers.CARVERS, UGEffects.EFFECTS, UGEntityTypes.ENTITIES, UGFeatures.FEATURES, UGFluids.FLUIDS, UGItems.ITEMS, UGParticleTypes.PARTICLES, UGPointOfInterests.POI, UGPotions.POTIONS, UGSoundEvents.SOUNDS, UGStructures.STRUCTURES, UGBlockEntities.BLOCK_ENTITIES, UGTreeDecoratorTypes.TREE_DECORATORS}) {
            register.register(bus);
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Registry.m_122965_((Registry)Registry.f_122859_, (ResourceLocation)new ResourceLocation(MODID, "smogstem_trunk_placer"), UGTrunkPlacerTypes.SMOGSTEM_TRUNK_PLACER);
            UGConfiguredFeatures.init();
            UGPlacedFeatures.init();
            UGConfiguredCarvers.init();
            UGConfiguredCarvers.init();
            UGEntityTypes.spawnPlacements();
            UGCriteria.register();
            UGBiomes.toDictionary();
            AxeItem.f_150683_ = Maps.newHashMap((Map)AxeItem.f_150683_);
            AxeItem.f_150683_.put((Block)UGBlocks.SMOGSTEM_LOG.get(), (Block)UGBlocks.STRIPPED_SMOGSTEM_LOG.get());
            AxeItem.f_150683_.put((Block)UGBlocks.SMOGSTEM_WOOD.get(), (Block)UGBlocks.STRIPPED_SMOGSTEM_WOOD.get());
            AxeItem.f_150683_.put((Block)UGBlocks.WIGGLEWOOD_LOG.get(), (Block)UGBlocks.STRIPPED_WIGGLEWOOD_LOG.get());
            AxeItem.f_150683_.put((Block)UGBlocks.WIGGLEWOOD_WOOD.get(), (Block)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD.get());
            AxeItem.f_150683_.put((Block)UGBlocks.GRONGLE_LOG.get(), (Block)UGBlocks.STRIPPED_GRONGLE_LOG.get());
            AxeItem.f_150683_.put((Block)UGBlocks.GRONGLE_WOOD.get(), (Block)UGBlocks.STRIPPED_GRONGLE_WOOD.get());
            HoeItem.f_41332_.put((Block)UGBlocks.DEEPTURF_BLOCK.get(), Pair.of(HoeItem::m_150856_, (Object)HoeItem.m_150858_((BlockState)((Block)UGBlocks.DEEPSOIL_FARMLAND.get()).m_49966_())));
            HoeItem.f_41332_.put((Block)UGBlocks.DEEPSOIL.get(), Pair.of(HoeItem::m_150856_, (Object)HoeItem.m_150858_((BlockState)((Block)UGBlocks.DEEPSOIL_FARMLAND.get()).m_49966_())));
            HoeItem.f_41332_.put((Block)UGBlocks.COARSE_DEEPSOIL.get(), Pair.of(HoeItem::m_150856_, (Object)HoeItem.m_150858_((BlockState)((Block)UGBlocks.DEEPSOIL.get()).m_49966_())));
            DefaultDispenseItemBehavior bucketBehavior = new DefaultDispenseItemBehavior(){
                private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

                public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    BucketItem bucketitem = (BucketItem)stack.m_41720_();
                    BlockPos blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                    ServerLevel world = source.m_7727_();
                    if (bucketitem.m_142073_(null, (Level)world, blockpos, null)) {
                        bucketitem.m_142131_(null, (Level)world, stack, blockpos);
                        return new ItemStack((ItemLike)Items.f_42446_);
                    }
                    return this.defaultBehavior.m_6115_(source, stack);
                }
            };
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.VIRULENT_MIX_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.GWIBLING_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                    return (Projectile)Util.m_137469_((Object)((Object)new SlingshotAmmoEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stackIn));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.GOO_BALL.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                    return (Projectile)Util.m_137469_((Object)((Object)new GooBallEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stackIn));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                    return (Projectile)Util.m_137469_((Object)((Object)new RottenBlisterberryEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stackIn));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.BLISTERBOMB.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                    return (Projectile)Util.m_137469_((Object)((Object)new BlisterbombEntity(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stackIn));
                }
            });
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Block)UGBlocks.BLOOD_MUSHROOM_GLOBULE.get()).m_5456_(), (Potion)((Potion)UGPotions.BRITTLENESS.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.BRITTLENESS.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_BRITTLENESS.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.BRITTLENESS.get()), (Item)Items.f_42525_, (Potion)((Potion)UGPotions.STRONG_BRITTLENESS.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Block)UGBlocks.VEIL_MUSHROOM.get()).m_5456_(), (Potion)((Potion)UGPotions.FEATHERWEIGHT.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.FEATHERWEIGHT.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_FEATHERWEIGHT.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.FEATHERWEIGHT.get()), (Item)Items.f_42525_, (Potion)((Potion)UGPotions.STRONG_FEATHERWEIGHT.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((StemGrownBlock)UGBlocks.GLOOMGOURD.get()).m_5456_(), (Potion)((Potion)UGPotions.VIRULENT_RESISTANCE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.VIRULENT_RESISTANCE.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_VIRULENT_RESISTANCE.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)UGItems.DROOPFRUIT.get()), (Potion)((Potion)UGPotions.GLOWING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.GLOWING.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_GLOWING.get()));
            ComposterBlock.m_51920_((float)0.1f, (ItemLike)((ItemLike)UGItems.DROOPFRUIT.get()));
            ComposterBlock.m_51920_((float)0.1f, (ItemLike)((ItemLike)UGItems.UNDERBEANS.get()));
            ComposterBlock.m_51920_((float)0.2f, (ItemLike)((ItemLike)UGItems.BLISTERBERRY.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGItems.GLOOMGOURD_SEEDS.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGItems.GLITTERKELP.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.SMOGSTEM_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.WIGGLEWOOD_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.GRONGLE_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.SMOGSTEM_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.WIGGLEWOOD_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.GRONGLE_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.DEEPTURF.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.SHIMMERWEED.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)UGBlocks.TALL_DEEPTURF.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)UGItems.DITCHBULB.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)UGBlocks.TALL_SHIMMERWEED.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.VEIL_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.INK_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.GLOOMGOURD.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.CARVED_GLOOMGOURD.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM_STALK.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.VEIL_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.VEIL_MUSHROOM_STALK.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.INK_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM_GLOBULE.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM_STALK.get()));
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.f_50276_;
            pot.addPlant(UGBlocks.SMOGSTEM_SAPLING.getId(), UGBlocks.POTTED_SMOGSTEM_SAPLING);
            pot.addPlant(UGBlocks.WIGGLEWOOD_SAPLING.getId(), UGBlocks.POTTED_WIGGLEWOOD_SAPLING);
            pot.addPlant(UGBlocks.SHIMMERWEED.getId(), UGBlocks.POTTED_SHIMMERWEED);
            pot.addPlant(UGBlocks.INDIGO_MUSHROOM.getId(), UGBlocks.POTTED_INDIGO_MUSHROOM);
            pot.addPlant(UGBlocks.VEIL_MUSHROOM.getId(), UGBlocks.POTTED_VEIL_MUSHROOM);
            pot.addPlant(UGBlocks.INK_MUSHROOM.getId(), UGBlocks.POTTED_INK_MUSHROOM);
            pot.addPlant(UGBlocks.BLOOD_MUSHROOM.getId(), UGBlocks.POTTED_BLOOD_MUSHROOM);
            pot.addPlant(UGBlocks.GRONGLE_SAPLING.getId(), UGBlocks.POTTED_GRONGLE_SAPLING);
            WoodType.m_61844_((WoodType)UGBlocks.SMOGSTEM_WOODTYPE);
            WoodType.m_61844_((WoodType)UGBlocks.WIGGLEWOOD_WOODTYPE);
            WoodType.m_61844_((WoodType)UGBlocks.GRONGLE_WOODTYPE);
        });
    }

    public void clientSetup(FMLClientSetupEvent event) {
        UndergardenClient.registerBlockRenderers();
        event.enqueueWork(() -> {
            Sheets.addWoodType((WoodType)UGBlocks.SMOGSTEM_WOODTYPE);
            Sheets.addWoodType((WoodType)UGBlocks.WIGGLEWOOD_WOODTYPE);
            Sheets.addWoodType((WoodType)UGBlocks.GRONGLE_WOODTYPE);
        });
        ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / 20.0f;
        });
        ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)UGItems.CLOGGRUM_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        DimensionSpecialEffects.f_108857_.put((Object)UGDimensions.UNDERGARDEN_LEVEL.m_135782_(), (Object)new DimensionSpecialEffects(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, true){

            public Vec3 m_5927_(Vec3 fogColor, float brightness) {
                return fogColor;
            }

            public boolean m_5781_(int x, int y) {
                return false;
            }
        });
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new UGBlockStates(generator, helper));
            generator.m_123914_((DataProvider)new UGItemModels(generator, helper));
            generator.m_123914_((DataProvider)new UGLang(generator));
            generator.m_123914_((DataProvider)new UGSoundDefinitions(generator, helper));
        }
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new UGRecipes(generator));
            generator.m_123914_((DataProvider)new UGLootTables(generator));
            UGBlockTags blockTags = new UGBlockTags(generator, helper);
            generator.m_123914_((DataProvider)blockTags);
            generator.m_123914_((DataProvider)new UGItemTags(generator, blockTags, helper));
            generator.m_123914_((DataProvider)new UGEntityTags(generator, helper));
            generator.m_123914_((DataProvider)new UGAdvancements(generator, helper));
            generator.m_123914_((DataProvider)new UGFluidTags(generator, helper));
        }
    }
}

