/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGTags;
import quek.undergarden.world.UGTeleporter;

public class UndergardenPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public UndergardenPortalBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76298_).m_60978_(-1.0f).m_60910_().m_60953_(state -> 10).m_60993_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public boolean trySpawnPortal(LevelAccessor worldIn, BlockPos pos) {
        Size UndergardenPortalBlock$size = this.isPortal(worldIn, pos);
        if (UndergardenPortalBlock$size != null && !UndergardenPortalBlock.onTrySpawnPortal(worldIn, pos, UndergardenPortalBlock$size)) {
            UndergardenPortalBlock$size.placePortalBlocks();
            return true;
        }
        return false;
    }

    public static boolean onTrySpawnPortal(LevelAccessor world, BlockPos pos, Size size) {
        return MinecraftForge.EVENT_BUS.post((Event)new PortalSpawnEvent(world, pos, world.m_8055_(pos), size));
    }

    @Nullable
    public Size isPortal(LevelAccessor worldIn, BlockPos pos) {
        Size UndergardenPortalBlock$size = new Size(worldIn, pos, Direction.Axis.X);
        if (UndergardenPortalBlock$size.isValid() && UndergardenPortalBlock$size.portalBlockCount == 0) {
            return UndergardenPortalBlock$size;
        }
        Size UndergardenPortalBlock$size1 = new Size(worldIn, pos, Direction.Axis.Z);
        return UndergardenPortalBlock$size1.isValid() && UndergardenPortalBlock$size1.portalBlockCount == 0 ? UndergardenPortalBlock$size1 : null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.m_122434_();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.m_61143_(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.m_122479_();
        return !flag && facingState.m_60734_() != this && !new Size(worldIn, currentPos, direction$axis1).validatePortal() ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            } else {
                Level entityWorld;
                if (!entity.f_19853_.f_46443_ && !pos.equals((Object)entity.f_19819_)) {
                    entity.f_19819_ = pos.m_7949_();
                }
                if ((entityWorld = entity.f_19853_) != null) {
                    ServerLevel destinationWorld;
                    ResourceKey<Level> destination;
                    MinecraftServer minecraftserver = entityWorld.m_142572_();
                    ResourceKey<Level> resourceKey = destination = entity.f_19853_.m_46472_() == UGDimensions.UNDERGARDEN_LEVEL ? Level.f_46428_ : UGDimensions.UNDERGARDEN_LEVEL;
                    if (minecraftserver != null && (destinationWorld = minecraftserver.m_129880_(destination)) != null && minecraftserver.m_7079_() && !entity.m_20159_()) {
                        entity.f_19853_.m_46473_().m_6180_("undergarden_portal");
                        entity.m_20091_();
                        entity.changeDimension(destinationWorld, (ITeleporter)new UGTeleporter(destinationWorld));
                        entity.f_19853_.m_46473_().m_7238_();
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)UGSoundEvents.UNDERGARDEN_PORTAL_AMBIENT.get(), SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.m_123341_() + rand.nextDouble();
            double y = (double)pos.m_123342_() + rand.nextDouble();
            double z = (double)pos.m_123343_() + rand.nextDouble();
            double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double ySpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double zSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (!worldIn.m_8055_(pos.m_142125_()).m_60713_((Block)this) && !worldIn.m_8055_(pos.m_142126_()).m_60713_((Block)this)) {
                x = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                xSpeed = rand.nextFloat() * 2.0f * (float)j;
            } else {
                z = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                zSpeed = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.m_7106_((ParticleOptions)UGParticleTypes.UNDERGARDEN_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public static class Size {
        private final LevelAccessor level;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(LevelAccessor level, BlockPos pos, Direction.Axis axis) {
            this.level = level;
            this.axis = axis;
            if (axis == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.m_123342_() > blockpos.m_123342_() - 21 && pos.m_123342_() > 0 && this.canConnect(level.m_8055_(pos.m_7495_()))) {
                pos = pos.m_7495_();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.m_5484_(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.canConnect(this.level.m_8055_(blockpos = pos.m_5484_(directionIn, i))) && this.level.m_8055_(blockpos.m_7495_()).m_204336_(UGTags.Blocks.PORTAL_FRAME_BLOCKS); ++i) {
            }
            BlockPos framePos = pos.m_5484_(directionIn, i);
            return this.level.m_8055_(framePos).m_204336_(UGTags.Blocks.PORTAL_FRAME_BLOCKS) ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos framePos;
                    BlockPos blockpos = this.bottomLeft.m_5484_(this.rightDir, i).m_6630_(this.height);
                    BlockState blockstate = this.level.m_8055_(blockpos);
                    if (!this.canConnect(blockstate)) break block0;
                    Block block = blockstate.m_60734_();
                    if (block == UGBlocks.UNDERGARDEN_PORTAL.get()) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.level.m_8055_(framePos = blockpos.m_142300_(this.leftDir)).m_204336_(UGTags.Blocks.PORTAL_FRAME_BLOCKS) : i == this.width - 1 && !this.level.m_8055_(framePos = blockpos.m_142300_(this.rightDir)).m_204336_(UGTags.Blocks.PORTAL_FRAME_BLOCKS)) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.m_5484_(this.rightDir, j).m_6630_(this.height);
                if (this.level.m_8055_(framePos).m_204336_(UGTags.Blocks.PORTAL_FRAME_BLOCKS)) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean canConnect(BlockState pos) {
            Block block = pos.m_60734_();
            return pos.m_60795_() || block == UGBlocks.UNDERGARDEN_PORTAL.get();
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.m_5484_(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.level.m_7731_(blockpos.m_6630_(j), (BlockState)((Block)UGBlocks.UNDERGARDEN_PORTAL.get()).m_49966_().m_61124_(AXIS, (Comparable)this.axis), 18);
                }
            }
        }

        private boolean isPortalCountValidForSize() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean validatePortal() {
            return this.isValid() && this.isPortalCountValidForSize();
        }
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final Size size;

        public PortalSpawnEvent(LevelAccessor world, BlockPos pos, BlockState state, Size size) {
            super(world, pos, state);
            this.size = size;
        }

        public Size getPortalSize() {
            return this.size;
        }
    }
}

