/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client;

import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import quek.undergarden.client.model.BruteModel;
import quek.undergarden.client.model.DwellerModel;
import quek.undergarden.client.model.ForgottenGuardianModel;
import quek.undergarden.client.model.GloomperModel;
import quek.undergarden.client.model.GwibModel;
import quek.undergarden.client.model.GwiblingModel;
import quek.undergarden.client.model.MasticatorModel;
import quek.undergarden.client.model.MinionModel;
import quek.undergarden.client.model.MogModel;
import quek.undergarden.client.model.MuncherModel;
import quek.undergarden.client.model.NargoyleModel;
import quek.undergarden.client.model.RotbeastModel;
import quek.undergarden.client.model.RotlingModel;
import quek.undergarden.client.model.RotwalkerModel;
import quek.undergarden.client.model.ScintlingModel;
import quek.undergarden.client.model.SploogieModel;
import quek.undergarden.client.model.StonebornModel;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.client.render.blockentity.DepthrockBedRender;
import quek.undergarden.client.render.entity.BruteRender;
import quek.undergarden.client.render.entity.DwellerRender;
import quek.undergarden.client.render.entity.ForgottenGuardianRender;
import quek.undergarden.client.render.entity.GloomperRender;
import quek.undergarden.client.render.entity.GwibRender;
import quek.undergarden.client.render.entity.GwiblingRender;
import quek.undergarden.client.render.entity.MasticatorRender;
import quek.undergarden.client.render.entity.MinionRender;
import quek.undergarden.client.render.entity.MogRender;
import quek.undergarden.client.render.entity.MuncherRender;
import quek.undergarden.client.render.entity.NargoyleRender;
import quek.undergarden.client.render.entity.RotbeastRender;
import quek.undergarden.client.render.entity.RotlingRender;
import quek.undergarden.client.render.entity.RotwalkerRender;
import quek.undergarden.client.render.entity.ScintlingRender;
import quek.undergarden.client.render.entity.SploogieRender;
import quek.undergarden.client.render.entity.StonebornRender;
import quek.undergarden.client.render.entity.UGBoatRenderer;
import quek.undergarden.entity.UGBoatEntity;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGFluids;

@Mod.EventBusSubscriber(modid="undergarden", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class UndergardenClient {
    private static void render(Supplier<? extends Block> block, RenderType render) {
        ItemBlockRenderTypes.setRenderLayer((Block)block.get(), (RenderType)render);
    }

    public static void registerBlockRenderers() {
        RenderType cutout = RenderType.m_110463_();
        RenderType mipped = RenderType.m_110457_();
        RenderType translucent = RenderType.m_110466_();
        UndergardenClient.render(UGBlocks.DEEPTURF_BLOCK, mipped);
        UndergardenClient.render(UGBlocks.DEEPTURF, cutout);
        UndergardenClient.render(UGBlocks.SHIMMERWEED, cutout);
        UndergardenClient.render(UGBlocks.SMOGSTEM_SAPLING, cutout);
        UndergardenClient.render(UGBlocks.WIGGLEWOOD_SAPLING, cutout);
        UndergardenClient.render(UGBlocks.INDIGO_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.VEIL_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.INK_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.BLOOD_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.UNDERBEAN_BUSH, cutout);
        UndergardenClient.render(UGBlocks.DITCHBULB_PLANT, cutout);
        UndergardenClient.render(UGBlocks.TALL_DEEPTURF, cutout);
        UndergardenClient.render(UGBlocks.TALL_SHIMMERWEED, cutout);
        UndergardenClient.render(UGBlocks.CLOGGRUM_BARS, cutout);
        UndergardenClient.render(UGBlocks.GLITTERKELP, cutout);
        UndergardenClient.render(UGBlocks.GLITTERKELP_PLANT, cutout);
        UndergardenClient.render(UGBlocks.GOO, translucent);
        UndergardenClient.render(UGBlocks.SMOGSTEM_DOOR, cutout);
        UndergardenClient.render(UGBlocks.WIGGLEWOOD_DOOR, cutout);
        UndergardenClient.render(UGBlocks.SMOGSTEM_TRAPDOOR, cutout);
        UndergardenClient.render(UGBlocks.WIGGLEWOOD_TRAPDOOR, cutout);
        UndergardenClient.render(UGBlocks.ASHEN_DEEPTURF, cutout);
        UndergardenClient.render(UGBlocks.BLISTERBERRY_BUSH, cutout);
        UndergardenClient.render(UGBlocks.GLOOMGOURD_STEM, cutout);
        UndergardenClient.render(UGBlocks.GLOOMGOURD_STEM_ATTACHED, cutout);
        UndergardenClient.render(UGBlocks.SHARD_TORCH, cutout);
        UndergardenClient.render(UGBlocks.SHARD_WALL_TORCH, cutout);
        UndergardenClient.render(UGBlocks.DROOPVINE, cutout);
        UndergardenClient.render(UGBlocks.DROOPVINE_PLANT, cutout);
        UndergardenClient.render(UGBlocks.GRONGLE_SAPLING, cutout);
        UndergardenClient.render(UGBlocks.GRONGLE_DOOR, cutout);
        UndergardenClient.render(UGBlocks.GRONGLE_TRAPDOOR, cutout);
        UndergardenClient.render(UGBlocks.SEEPING_INK, cutout);
        UndergardenClient.render(UGBlocks.MUSHROOM_VEIL_PLANT, cutout);
        UndergardenClient.render(UGBlocks.MUSHROOM_VEIL, cutout);
        UndergardenClient.render(UGBlocks.POTTED_SHIMMERWEED, cutout);
        UndergardenClient.render(UGBlocks.POTTED_SMOGSTEM_SAPLING, cutout);
        UndergardenClient.render(UGBlocks.POTTED_WIGGLEWOOD_SAPLING, cutout);
        UndergardenClient.render(UGBlocks.POTTED_INDIGO_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.POTTED_VEIL_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.POTTED_INDIGO_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.POTTED_INK_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.POTTED_BLOOD_MUSHROOM, cutout);
        UndergardenClient.render(UGBlocks.POTTED_GRONGLE_SAPLING, cutout);
        UndergardenClient.render(UGBlocks.FROZEN_DEEPTURF, cutout);
        UndergardenClient.render(UGBlocks.SEDIMENT_GLASS, translucent);
        UndergardenClient.render(UGBlocks.SEDIMENT_GLASS_PANE, translucent);
        UndergardenClient.render(UGBlocks.HANGING_GRONGLE_LEAVES, cutout);
        UndergardenClient.render(UGBlocks.GOO_BLOCK, translucent);
        UndergardenClient.render(UGBlocks.CLOGGRUM_LANTERN, cutout);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.DEPTHROCK_BED.get(), DepthrockBedRender::new);
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.UNDERGARDEN_SIGN.get(), SignRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BOAT.get(), UGBoatRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SLINGSHOT_AMMO.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GOO_BALL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTTEN_BLISTERBERRY.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BLISTERBOMB.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MINION_PROJECTILE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MINION.get(), MinionRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTLING.get(), RotlingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTWALKER.get(), RotwalkerRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTBEAST.get(), RotbeastRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.DWELLER.get(), DwellerRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GWIBLING.get(), GwiblingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BRUTE.get(), BruteRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SCINTLING.get(), ScintlingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GLOOMPER.get(), GloomperRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.STONEBORN.get(), StonebornRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.NARGOYLE.get(), NargoyleRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MUNCHER.get(), MuncherRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SPLOOGIE.get(), SploogieRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GWIB.get(), GwibRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MOG.get(), MogRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MASTICATOR.get(), MasticatorRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get(), ForgottenGuardianRender::new);
    }

    @SubscribeEvent
    public static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(UGModelLayers.DEPTHROCK_BED_HEAD, DepthrockBedRender::createHeadLayer);
        event.registerLayerDefinition(UGModelLayers.DEPTHROCK_BED_FOOT, DepthrockBedRender::createFootLayer);
        for (UGBoatEntity.Type boatType : UGBoatEntity.Type.values()) {
            event.registerLayerDefinition(UGBoatRenderer.boatLayer(boatType), BoatModel::m_170463_);
        }
        event.registerLayerDefinition(UGModelLayers.MINION, MinionModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTLING, RotlingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTWALKER, RotwalkerModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTBEAST, RotbeastModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.DWELLER, () -> DwellerModel.createBodyLayer(0.0f));
        event.registerLayerDefinition(UGModelLayers.DWELLER_SADDLE, () -> DwellerModel.createBodyLayer(0.5f));
        event.registerLayerDefinition(UGModelLayers.GWIBLING, GwiblingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.BRUTE, BruteModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.SCINTLING, ScintlingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.GLOOMPER, GloomperModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.STONEBORN, StonebornModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.NARGOYLE, NargoyleModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MUNCHER, MuncherModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.SPLOOGIE, SploogieModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.GWIB, GwibModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MOG, MogModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MASTICATOR, MasticatorModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.FORGOTTEN_GUARDIAN, ForgottenGuardianModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.m_92589_((state, tintGetter, pos, tint) -> tintGetter != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)tintGetter, (BlockPos)pos) : new Color(91, 117, 91).getRGB(), new Block[]{(Block)UGBlocks.DEEPTURF_BLOCK.get(), (Block)UGBlocks.DEEPTURF.get(), (Block)UGBlocks.SHIMMERWEED.get(), (Block)UGBlocks.TALL_DEEPTURF.get(), (Block)UGBlocks.TALL_SHIMMERWEED.get(), (Block)UGBlocks.GLOOMGOURD_STEM.get(), (Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get(), (Block)UGBlocks.POTTED_SHIMMERWEED.get(), (Block)UGBlocks.DROOPVINE.get(), (Block)UGBlocks.DROOPVINE_PLANT.get()});
        colors.m_92589_((state, world, pos, tint) -> new Color(54, 45, 66).getRGB(), new Block[]{(Block)UGBlocks.GLOOMGOURD_STEM.get(), (Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(ColorHandlerEvent.Item event) {
        BlockColors bColors = event.getBlockColors();
        ItemColors iColors = event.getItemColors();
        iColors.m_92689_((stack, tint) -> bColors.m_92577_(((BlockItem)stack.m_41720_()).m_40614_().m_49966_(), null, null, 0), new ItemLike[]{(ItemLike)UGBlocks.DEEPTURF_BLOCK.get(), (ItemLike)UGBlocks.DEEPTURF.get(), (ItemLike)UGBlocks.SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_DEEPTURF.get()});
        iColors.m_92689_((stack, tint) -> {
            if (tint == 0) {
                return new Color(91, 117, 91).getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)UGBlocks.SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_SHIMMERWEED.get()});
    }

    @Mod.EventBusSubscriber(modid="undergarden", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void renderVirulentFogColor(EntityViewRenderEvent.FogColors event) {
            Camera camera = event.getCamera();
            FluidState fluidState = camera.getBlockAtCamera().m_60819_();
            if (fluidState.m_76152_() == UGFluids.VIRULENT_MIX_FLOWING.get() || fluidState.m_76152_() == UGFluids.VIRULENT_MIX_SOURCE.get()) {
                event.setRed(0.22352941f);
                event.setGreen(0.09803922f);
                event.setBlue(0.3137255f);
            }
        }

        @SubscribeEvent
        public static void renderVirulentFogDensity(EntityViewRenderEvent.FogDensity event) {
            Camera camera = event.getCamera();
            FluidState fluidState = camera.getBlockAtCamera().m_60819_();
            if (fluidState.m_76152_() == UGFluids.VIRULENT_MIX_FLOWING.get() || fluidState.m_76152_() == UGFluids.VIRULENT_MIX_SOURCE.get()) {
                event.setDensity(15.0f);
                event.setCanceled(true);
            }
        }
    }
}

