/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.boss.ForgottenGuardianEntity;

public class ForgottenGuardianModel<T extends ForgottenGuardianEntity>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public ForgottenGuardianModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.leftArm = this.body.m_171324_("leftArm");
        this.rightArm = this.body.m_171324_("rightArm");
        this.leftLeg = root.m_171324_("leftLeg");
        this.rightLeg = root.m_171324_("rightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(48, 11).m_171488_(-5.0f, 0.0f, -4.0f, 10.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(48, 45).m_171488_(-3.0f, -14.0f, -3.0f, 6.0f, 17.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(41, 69).m_171488_(-3.0f, -13.0f, -5.0f, 6.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(76, 0).m_171488_(-3.0f, -13.0f, -4.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(42, 0).m_171488_(-2.0f, -7.0f, -2.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)1.0f));
        PartDefinition chest = body.m_171599_("chest", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)6.0f));
        PartDefinition torso = chest.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -9.0f, -9.0f, 16.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(64, 60).m_171488_(-7.0f, -2.0f, -4.0f, 7.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 73).m_171488_(-5.0f, 6.0f, -3.0f, 4.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(28, 19).m_171488_(-6.0f, 18.0f, -4.0f, 6.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)-19.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(56, 23).m_171488_(0.0f, -2.0f, -4.0f, 7.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(72, 39).m_171488_(1.0f, 6.0f, -3.0f, 4.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 19).m_171488_(0.0f, 18.0f, -4.0f, 6.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.0f, (float)-19.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition rightLeg = partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(67, 76).m_171488_(-3.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(24, 45).m_171488_(-4.0f, 11.0f, -3.0f, 6.0f, 22.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-9.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(20, 73).m_171488_(-1.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 45).m_171488_(-2.0f, 11.0f, -3.0f, 6.0f, 22.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-9.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.leftLeg.f_104203_ = -1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightLeg.f_104203_ = 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        int attackTimer = ((ForgottenGuardianEntity)((Object)entityIn)).getAttackTimer();
        if (attackTimer > 0) {
            this.rightArm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)attackTimer - partialTick), (float)10.0f);
            this.leftArm.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)attackTimer - partialTick), (float)10.0f);
        } else {
            this.rightArm.f_104203_ = (-0.2f + 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftArm.f_104203_ = (-0.2f - 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableSet.of((Object)this.body, (Object)this.leftLeg, (Object)this.rightLeg);
    }
}

