/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.GloomperEntity;

public class GloomperModel<T extends GloomperEntity>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart arms;
    private final ModelPart feet;
    private float jumpRotation;

    public GloomperModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.arms = root.m_171324_("arms");
        this.feet = root.m_171324_("feet");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -5.0f, -8.0f, 16.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-5.0f, -4.5f, -2.0f, 10.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)-5.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-5.0f, -4.0f, -1.0f, 10.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)-2.0f));
        PartDefinition arms = partdefinition.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)19.5f, (float)-3.5f));
        PartDefinition left = arms.m_171599_("left", CubeListBuilder.m_171558_().m_171514_(22, 43).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)6.0f, (float)-0.5f, (float)-1.0f, (float)-0.5672f, (float)-0.4363f, (float)0.0f));
        PartDefinition right = arms.m_171599_("right", CubeListBuilder.m_171558_().m_171514_(22, 43).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)-0.5f, (float)-1.0f, (float)-0.5672f, (float)0.4363f, (float)0.0f));
        PartDefinition feet = partdefinition.m_171599_("feet", CubeListBuilder.m_171558_().m_171514_(28, 32).m_171480_().m_171488_(7.0f, 5.0f, -7.0f, 4.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(28, 32).m_171488_(-11.0f, 5.0f, -7.0f, 4.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 56).m_171488_(-11.0f, 0.0f, -3.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 56).m_171480_().m_171488_(7.0f, 0.0f, -3.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float age = ageInTicks - (float)((GloomperEntity)((Object)entity)).f_19797_;
        this.jumpRotation = Mth.m_14031_((float)(((GloomperEntity)((Object)entity)).getJumpCompletion(age) * (float)Math.PI));
        this.arms.f_104203_ = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.feet.f_104203_ = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.jumpRotation = Mth.m_14031_((float)(((GloomperEntity)((Object)entityIn)).getJumpCompletion(partialTick) * (float)Math.PI));
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableSet.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableSet.of((Object)this.body, (Object)this.head, (Object)this.arms, (Object)this.feet);
    }
}

