/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.ScintlingEntity;

public class ScintlingModel<T extends ScintlingEntity>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart leftStalk;
    private final ModelPart rightStalk;
    private final ModelPart torso;
    private final ModelPart tail;

    public ScintlingModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.leftStalk = this.head.m_171324_("leftStalk");
        this.rightStalk = this.head.m_171324_("rightStalk");
        this.torso = root.m_171324_("torso");
        this.tail = root.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition tail = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-4.0f, -2.0f, 0.0f, 8.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 28).m_171488_(-3.0f, -1.0f, 5.0f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)6.0f));
        PartDefinition torso = partdefinition.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -7.0f, 8.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(26, 18).m_171488_(-3.0f, -2.0f, -6.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)-7.0f));
        PartDefinition leftStalk = head.m_171599_("leftStalk", CubeListBuilder.m_171558_().m_171514_(20, 28).m_171488_(0.0f, -7.0f, -1.0f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-2.0f, (float)-5.0f, (float)0.3491f, (float)0.0f, (float)0.1745f));
        PartDefinition rightStalk = head.m_171599_("rightStalk", CubeListBuilder.m_171558_().m_171514_(20, 28).m_171480_().m_171488_(-1.0f, -7.0f, -1.0f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)-2.0f, (float)-5.0f, (float)0.3491f, (float)0.0f, (float)-0.1745f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float wiggle;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.torso.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * 0.5f * limbSwingAmount;
        this.leftStalk.f_104203_ = wiggle = Mth.m_14031_((float)((float)((ScintlingEntity)((Object)entity)).f_19797_ * 0.3f)) * 0.3f;
        this.rightStalk.f_104203_ = -wiggle;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.head, (Object)this.torso, (Object)this.tail);
    }
}

