/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.stoneborn.StonebornEntity;

public class StonebornModel<T extends StonebornEntity>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public StonebornModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.leftArm = root.m_171324_("leftArm");
        this.rightArm = root.m_171324_("rightArm");
        this.leftLeg = root.m_171324_("leftLeg");
        this.rightLeg = root.m_171324_("rightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -12.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(-5.0f, -11.0f, -5.0f, 10.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 8).m_171488_(-7.0f, -10.0f, 0.0f, 14.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 12).m_171488_(7.0f, -13.0f, 0.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(40, 12).m_171488_(-9.0f, -15.0f, 0.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(48, 12).m_171488_(4.0f, -8.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-1.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.75f, (float)-3.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-6.0f, -7.0f, -4.0f, 12.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)1.0f));
        PartDefinition robe = body.m_171599_("robe", CubeListBuilder.m_171558_().m_171514_(40, 21).m_171488_(-6.0f, -7.0f, -4.0f, 12.0f, 14.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-4.0f, -0.5f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-2.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition rightArm = partdefinition.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171480_().m_171488_(-1.0f, -0.5f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)7.0f, (float)-2.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition leftLeg = partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-3.0f, 0.0f, -1.0f, 5.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(70, 48).m_171488_(-3.0f, 0.0f, -1.0f, 5.0f, 15.0f, 4.0f, new CubeDeformation(0.24f)), PartPose.m_171419_((float)-3.0f, (float)9.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171480_().m_171488_(-2.0f, 0.0f, -1.0f, 5.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(70, 48).m_171480_().m_171488_(-2.0f, 0.0f, -1.0f, 5.0f, 15.0f, 4.0f, new CubeDeformation(0.24f)).m_171555_(false), PartPose.m_171419_((float)3.0f, (float)9.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)88, (int)67);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableSet.of((Object)this.head, (Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg, (Object[])new ModelPart[0]);
    }
}

