/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.entity.rotspawn.RotspawnEntity;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class DwellerEntity
extends Animal
implements ItemSteerable,
Saddleable {
    private static final EntityDataAccessor<Boolean> SADDLE = SynchedEntityData.m_135353_(DwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.m_135353_(DwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemBasedSteering steering;

    public DwellerEntity(EntityType<? extends DwellerEntity> type, Level level) {
        super(type, level);
        this.steering = new ItemBasedSteering(this.f_19804_, BOOST_TIME, SADDLE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.5));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UNDERBEANS.get(), (ItemLike)UGItems.UNDERBEAN_STICK.get()}), false));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, RotspawnEntity.class, 12.0f, 2.0, 2.5));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UGSoundEvents.DWELLER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.DWELLER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.DWELLER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)UGSoundEvents.DWELLER_STEP.get(), 0.15f, 1.0f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)UGEntityTypes.DWELLER.get()).m_20615_(this.f_19853_);
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UNDERBEANS.get()}).test(stack);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.steering.m_20847_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.steering.m_20852_(nbt);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SADDLE, (Object)false);
        this.f_19804_.m_135372_(BOOST_TIME, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (BOOST_TIME.equals(data) && this.f_19853_.f_46443_) {
            this.steering.m_20844_();
        }
        super.m_7350_(data);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean isFood = this.m_6898_(player.m_21120_(hand));
        if (!isFood && this.m_6254_() && !this.m_20160_() && !player.m_36341_()) {
            if (!this.f_19853_.f_46443_) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        InteractionResult actionresulttype = super.m_6071_(player, hand);
        if (!actionresulttype.m_19077_()) {
            ItemStack itemstack = player.m_21120_(hand);
            return itemstack.m_41720_() == Items.f_42450_ ? itemstack.m_41647_(player, (LivingEntity)this, hand) : InteractionResult.PASS;
        }
        return actionresulttype;
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public void m_5853_(@Nullable SoundSource sound) {
        this.steering.m_20849_(true);
        if (sound != null) {
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12236_, sound, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return this.steering.m_20851_();
    }

    public boolean m_6746_() {
        return this.steering.m_20845_(this.m_21187_());
    }

    public void m_7023_(Vec3 vector) {
        this.m_20854_((Mob)this, this.steering, vector);
    }

    public void m_7760_(Vec3 vector) {
        super.m_7023_(vector);
    }

    public float m_6748_() {
        return (float)this.m_21133_(Attributes.f_22279_) * 1.1f;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    public boolean m_5807_() {
        Entity entity = this.m_6688_();
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        return player.m_21205_().m_41720_() == UGItems.UNDERBEAN_STICK.get() || player.m_21206_().m_41720_() == UGItems.UNDERBEAN_STICK.get();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    public void m_7332_(Entity passenger) {
        float ySin = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float yCos = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        passenger.m_6034_(this.m_20185_() + (double)(0.5f * ySin), this.m_20186_() + this.m_6048_() + passenger.m_6049_() - (double)0.1f, this.m_20189_() - (double)(0.5f * yCos));
    }
}

