/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import quek.undergarden.registry.UGSoundEvents;

public class MasticatorEntity
extends Monster {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(false);

    public MasticatorEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_19793_ = 1.0f;
        this.f_21364_ = 25;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UGSoundEvents.MASTICATOR_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.MASTICATOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.MASTICATOR_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)UGSoundEvents.MASTICATOR_STEP.get(), 0.2f, 1.0f);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            double d0 = this.m_5448_() != null ? 0.35 : 0.3;
            double speed = this.m_21051_(Attributes.f_22279_).m_22115_();
            this.m_21051_(Attributes.f_22279_).m_22100_(Mth.m_14139_((double)0.1, (double)speed, (double)d0));
            if (this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                boolean flag = false;
                AABB axisalignedbb = this.m_142469_().m_82400_(0.2);
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)axisalignedbb.f_82288_), (int)Mth.m_14107_((double)axisalignedbb.f_82289_), (int)Mth.m_14107_((double)axisalignedbb.f_82290_), (int)Mth.m_14107_((double)axisalignedbb.f_82291_), (int)Mth.m_14107_((double)axisalignedbb.f_82292_), (int)Mth.m_14107_((double)axisalignedbb.f_82293_))) {
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    if (!(block instanceof LeavesBlock)) continue;
                    flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
                }
                if (!flag && this.f_19861_) {
                    this.m_6135_();
                }
            }
        }
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_5837_(ServerLevel level, LivingEntity entity) {
        super.m_5837_(level, entity);
        this.m_5634_(this.m_21223_() / 4.0f);
        this.m_5496_((SoundEvent)UGSoundEvents.MASTICATOR_EAT.get(), 1.0f, this.m_6100_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    protected void m_6731_(LivingEntity entity) {
        this.launch((Entity)entity);
        entity.f_19864_ = true;
    }

    private void launch(Entity target) {
        double distanceX = target.m_20185_() - this.m_20185_();
        double distanceZ = target.m_20189_() - this.m_20189_();
        double d2 = Math.max(distanceX * distanceX + distanceZ * distanceZ, 0.001);
        target.m_5997_(distanceX / d2 * 4.0, 0.2, distanceZ / d2 * 4.0);
    }
}

