/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.cavern;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.entity.cavern.CavernEntity;
import quek.undergarden.registry.UGSoundEvents;

public class NargoyleEntity
extends CavernEntity {
    public NargoyleEntity(EntityType<? extends CavernEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.2f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 64.0);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.NARGOYLE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.NARGOYLE_DEATH.get();
    }

    public boolean m_7327_(Entity entity) {
        this.m_5496_((SoundEvent)UGSoundEvents.NARGOYLE_ATTACK.get(), 1.0f, 1.0f);
        return super.m_7327_(entity);
    }

    public static class LeapAtTargetGoal
    extends Goal {
        private final Mob leaper;
        private LivingEntity leapTarget;
        private final float leapMotionY;

        public LeapAtTargetGoal(Mob mob, float leapMotionY) {
            this.leaper = mob;
            this.leapMotionY = leapMotionY;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.leaper.m_20160_()) {
                return false;
            }
            this.leapTarget = this.leaper.m_5448_();
            if (this.leapTarget == null) {
                return false;
            }
            double distance = this.leaper.m_20280_((Entity)this.leapTarget);
            if (!(distance < 4.0) && !(distance > 16.0)) {
                if (!this.leaper.m_20096_()) {
                    return false;
                }
                return this.leaper.m_21187_().nextInt(5) == 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return !this.leaper.m_20096_();
        }

        public void m_8056_() {
            Vec3 vector3d = this.leaper.m_20184_();
            Vec3 vector3d1 = new Vec3(this.leapTarget.m_20185_() - this.leaper.m_20185_(), 0.0, this.leapTarget.m_20189_() - this.leaper.m_20189_());
            if (vector3d1.m_82556_() > 1.0E-7) {
                vector3d1 = vector3d1.m_82541_().m_82490_(0.4).m_82549_(vector3d.m_82490_(0.2));
            }
            this.leaper.m_20334_(vector3d1.f_82479_ * 2.0, (double)this.leapMotionY, vector3d1.f_82481_ * 2.0);
        }
    }
}

