/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.tool;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.eventbus.api.Event;
import quek.undergarden.entity.projectile.SlingshotAmmoEntity;
import quek.undergarden.item.DepthrockPebbleItem;
import quek.undergarden.registry.UGItemGroups;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class SlingshotItem
extends ProjectileWeaponItem {
    public SlingshotItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(192).m_41491_(UGItemGroups.GROUP).m_41497_(Rarity.UNCOMMON));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tooltip.slingshot").m_130940_(ChatFormatting.GRAY));
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_41720_() == UGItems.DEPTHROCK_PEBBLE.get();
    }

    public int m_6615_() {
        return 10;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean creativeOrInfinity = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack itemstack = player.m_6298_(stack);
            int i = this.m_8105_(stack) - timeLeft;
            if ((i = SlingshotItem.onArrowLoose(stack, level, player, i, !itemstack.m_41619_() || creativeOrInfinity)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || creativeOrInfinity) {
                float f;
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)UGItems.DEPTHROCK_PEBBLE.get());
                }
                if (!((double)(f = SlingshotItem.getProjectileVelocity(i)) < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = player.m_150110_().f_35937_ || itemstack.m_41720_() instanceof DepthrockPebbleItem && ((DepthrockPebbleItem)itemstack.m_41720_()).isInfinite(itemstack, stack, player);
                    if (!level.f_46443_) {
                        SlingshotAmmoEntity ammoEntity = new SlingshotAmmoEntity(level, entity);
                        ammoEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.0f, 1.0f);
                        stack.m_41622_(1, (LivingEntity)player, player1 -> player.m_21190_(player.m_7655_()));
                        level.m_7967_((Entity)ammoEntity);
                    }
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)UGSoundEvents.SLINGSHOT_SHOOT.get(), SoundSource.PLAYERS, 0.5f, 1.0f / (level.m_5822_().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            player.m_150109_().m_36057_(itemstack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack itemstack;
        boolean hasAmmo = !player.m_6298_(itemstack = player.m_21120_(handIn)).m_41619_();
        InteractionResultHolder<ItemStack> ret = SlingshotItem.onArrowNock(itemstack, worldIn, player, handIn, hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (!player.m_150110_().f_35937_ && !hasAmmo) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(handIn);
        worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)UGSoundEvents.SLINGSHOT_DRAW.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public static InteractionResultHolder<ItemStack> onArrowNock(ItemStack item, Level world, Player player, InteractionHand hand, boolean hasAmmo) {
        ArrowNockEvent event = new ArrowNockEvent(player, item, hand, world, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
        }
        return event.getAction();
    }

    public static int onArrowLoose(ItemStack stack, Level world, Player player, int charge, boolean hasAmmo) {
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, world, charge, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getCharge();
    }

    public static float getProjectileVelocity(int charge) {
        float f = (float)charge / 5.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int m_8105_(ItemStack stack) {
        return 36000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(ItemTags.f_13168_);
    }
}

