/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import quek.undergarden.block.UndergardenPortalBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGPointOfInterests;

public class UGTeleporter
implements ITeleporter {
    protected final ServerLevel level;

    public UGTeleporter(ServerLevel worldIn) {
        this.level = worldIn;
    }

    public Optional<BlockUtil.FoundRectangle> getExistingPortal(BlockPos pos) {
        PoiManager poiManager = this.level.m_8904_();
        poiManager.m_27056_((LevelReader)this.level, pos, 64);
        Optional<PoiRecord> optional = poiManager.m_27166_(poiType -> poiType == UGPointOfInterests.UNDERGARDEN_PORTAL.get(), pos, 64, PoiManager.Occupancy.ANY).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)pos)).thenComparingInt(poi -> poi.m_27257_().m_123342_())).filter(poi -> this.level.m_8055_(poi.m_27257_()).m_61138_((Property)BlockStateProperties.f_61364_)).findFirst();
        return optional.map(poi -> {
            BlockPos blockpos = poi.m_27257_();
            this.level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.level.m_8055_(blockpos);
            return BlockUtil.m_124334_((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posIn -> this.level.m_8055_(posIn) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> makePortal(BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = this.level.m_6857_();
        int dimensionLogicalHeight = this.level.m_141928_() - 1;
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        for (BlockPos.MutableBlockPos blockpos$mutable1 : BlockPos.m_121935_((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(dimensionLogicalHeight, this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, blockpos$mutable1.m_123341_(), blockpos$mutable1.m_123343_()));
            if (!worldborder.m_61937_((BlockPos)blockpos$mutable1) || !worldborder.m_61937_((BlockPos)blockpos$mutable1.m_122175_(direction, 1))) continue;
            blockpos$mutable1.m_122175_(direction.m_122424_(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                blockpos$mutable1.m_142448_(l);
                if (!this.level.m_46859_((BlockPos)blockpos$mutable1)) continue;
                int i1 = l;
                while (l > 0 && this.level.m_46859_((BlockPos)blockpos$mutable1.m_122173_(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > dimensionLogicalHeight || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutable1.m_142448_(l);
                if (!this.checkRegionForPlacement((BlockPos)blockpos$mutable1, mutablePos, direction, 0)) continue;
                double d2 = pos.m_123331_((Vec3i)blockpos$mutable1);
                if (this.checkRegionForPlacement((BlockPos)blockpos$mutable1, mutablePos, direction, -1) && this.checkRegionForPlacement((BlockPos)blockpos$mutable1, mutablePos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutable1.m_7949_();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutable1.m_7949_();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(pos.m_123341_(), Mth.m_14045_((int)pos.m_123342_(), (int)70, (int)(this.level.m_141928_() - 10)), pos.m_123343_()).m_7949_();
            Direction direction1 = direction.m_122427_();
            if (!worldborder.m_61937_(blockpos)) {
                return Optional.empty();
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        BlockState blockstate1 = i3 < 0 ? Blocks.f_50222_.m_49966_() : Blocks.f_50016_.m_49966_();
                        mutablePos.m_122154_((Vec3i)blockpos, k2 * direction.m_122429_() + l1 * direction1.m_122429_(), i3, k2 * direction.m_122431_() + l1 * direction1.m_122431_());
                        this.level.m_46597_((BlockPos)mutablePos, blockstate1);
                    }
                }
            }
        }
        for (int k1 = -1; k1 < 3; ++k1) {
            for (int i2 = -1; i2 < 4; ++i2) {
                if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                mutablePos.m_122154_((Vec3i)blockpos, k1 * direction.m_122429_(), i2, k1 * direction.m_122431_());
                this.level.m_7731_((BlockPos)mutablePos, Blocks.f_50222_.m_49966_(), 3);
            }
        }
        BlockState undergardenPortal = (BlockState)((Block)UGBlocks.UNDERGARDEN_PORTAL.get()).m_49966_().m_61124_(UndergardenPortalBlock.AXIS, (Comparable)axis);
        for (int j2 = 0; j2 < 2; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                mutablePos.m_122154_((Vec3i)blockpos, j2 * direction.m_122429_(), l2, j2 * direction.m_122431_());
                this.level.m_7731_((BlockPos)mutablePos, undergardenPortal, 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.m_7949_(), 2, 3));
    }

    private boolean checkRegionForPlacement(BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction directionIn, int offsetScale) {
        Direction direction = directionIn.m_122427_();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.m_122154_((Vec3i)originalPos, directionIn.m_122429_() * i + direction.m_122429_() * offsetScale, j, directionIn.m_122431_() * i + direction.m_122431_() * offsetScale);
                if (j < 0 && !this.level.m_8055_((BlockPos)offsetPos).m_60767_().m_76333_()) {
                    return false;
                }
                if (j < 0 || this.level.m_46859_((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel level, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        boolean destinationIsUG;
        boolean bl = destinationIsUG = level.m_46472_() == UGDimensions.UNDERGARDEN_LEVEL;
        if (entity.f_19853_.m_46472_() != UGDimensions.UNDERGARDEN_LEVEL && !destinationIsUG) {
            return null;
        }
        WorldBorder border = level.m_6857_();
        double minX = Math.max(-2.9999872E7, border.m_61955_() + 16.0);
        double minZ = Math.max(-2.9999872E7, border.m_61956_() + 16.0);
        double maxX = Math.min(2.9999872E7, border.m_61957_() - 16.0);
        double maxZ = Math.min(2.9999872E7, border.m_61958_() - 16.0);
        double coordinateDifference = DimensionType.m_63908_((DimensionType)entity.f_19853_.m_6042_(), (DimensionType)level.m_6042_());
        BlockPos blockpos = new BlockPos(Mth.m_14008_((double)(entity.m_20185_() * coordinateDifference), (double)minX, (double)maxX), entity.m_20186_(), Mth.m_14008_((double)(entity.m_20189_() * coordinateDifference), (double)minZ, (double)maxZ));
        return this.getOrMakePortal(entity, blockpos).map(result -> {
            Vec3 vector3d;
            Direction.Axis axis;
            BlockState blockstate = entity.f_19853_.m_8055_(entity.f_19819_);
            if (blockstate.m_61138_((Property)BlockStateProperties.f_61364_)) {
                axis = (Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_);
                BlockUtil.FoundRectangle rectangle = BlockUtil.m_124334_((BlockPos)entity.f_19819_, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> entity.f_19853_.m_8055_(pos) == blockstate);
                vector3d = PortalShape.m_77738_((BlockUtil.FoundRectangle)rectangle, (Direction.Axis)axis, (Vec3)entity.m_20182_(), (EntityDimensions)entity.m_6972_(entity.m_20089_()));
            } else {
                axis = Direction.Axis.X;
                vector3d = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.m_77699_((ServerLevel)level, (BlockUtil.FoundRectangle)result, (Direction.Axis)axis, (Vec3)vector3d, (EntityDimensions)entity.m_6972_(entity.m_20089_()), (Vec3)entity.m_20184_(), (float)entity.m_146908_(), (float)entity.m_146909_());
        }).orElse(null);
    }

    protected Optional<BlockUtil.FoundRectangle> getOrMakePortal(Entity entity, BlockPos pos) {
        Optional<BlockUtil.FoundRectangle> existingPortal = this.getExistingPortal(pos);
        if (existingPortal.isPresent()) {
            return existingPortal;
        }
        Direction.Axis portalAxis = this.level.m_8055_(entity.f_19819_).m_61145_(UndergardenPortalBlock.AXIS).orElse(Direction.Axis.X);
        return this.makePortal(pos, portalAxis);
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
        return false;
    }
}

