/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import quek.undergarden.block.Droopvine;
import quek.undergarden.block.DroopvineBlock;
import quek.undergarden.block.DroopvinePlantBlock;
import quek.undergarden.registry.UGBlocks;

public class DroopvineFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] directionArray = Direction.values();

    public DroopvineFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.m_159774_();
        BlockPos pos = pContext.m_159777_();
        Random random = pContext.m_159776_();
        if (!level.m_46859_(pos)) {
            return false;
        }
        BlockState blockstate = level.m_8055_(pos.m_7494_());
        if (!blockstate.m_60713_((Block)UGBlocks.DEPTHROCK.get()) && !blockstate.m_60713_((Block)UGBlocks.SHIVERSTONE.get())) {
            return false;
        }
        this.placeRoofDroopvine((LevelAccessor)level, random, pos);
        return true;
    }

    private void placeRoofDroopvine(LevelAccessor world, Random rand, BlockPos pos) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            BlockState blockstate;
            posMutable.m_122154_((Vec3i)pos, rand.nextInt(8) - rand.nextInt(8), rand.nextInt(2) - rand.nextInt(7), rand.nextInt(8) - rand.nextInt(8));
            if (!world.m_46859_((BlockPos)posMutable) || !(blockstate = world.m_8055_(posMutable.m_7494_())).m_60713_((Block)UGBlocks.DEPTHROCK.get()) && !blockstate.m_60713_((Block)UGBlocks.SHIVERSTONE.get())) continue;
            int length = Mth.m_14072_((Random)rand, (int)1, (int)8);
            if (rand.nextInt(6) == 0) {
                length *= 2;
            }
            if (rand.nextInt(5) == 0) {
                length = 1;
            }
            DroopvineFeature.placeDroopvineColumn(world, rand, posMutable, length, 17, 25);
        }
    }

    public static void placeDroopvineColumn(LevelAccessor world, Random rand, BlockPos.MutableBlockPos posMutable, int length, int min, int max) {
        for (int i = 0; i <= length; ++i) {
            if (world.m_46859_((BlockPos)posMutable)) {
                if (i == length || !world.m_46859_(posMutable.m_7495_())) {
                    world.m_7731_((BlockPos)posMutable, (BlockState)((BlockState)((DroopvineBlock)UGBlocks.DROOPVINE.get()).m_49966_().m_61124_((Property)Droopvine.GLOWY, (Comparable)Boolean.valueOf(world.m_5822_().nextBoolean()))).m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_14072_((Random)rand, (int)min, (int)max))), 2);
                    break;
                }
                world.m_7731_((BlockPos)posMutable, (BlockState)((DroopvinePlantBlock)UGBlocks.DROOPVINE_PLANT.get()).m_49966_().m_61124_((Property)Droopvine.GLOWY, (Comparable)Boolean.valueOf(world.m_5822_().nextBoolean())), 2);
            }
            posMutable.m_122173_(Direction.DOWN);
        }
    }
}

