/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kobolds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.kobolds.entity.AbstractKoboldEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class KoboldChildModel<T extends AbstractKoboldEntity>
extends EntityModel<T>
implements HeadedModel {
    public static final ModelLayerLocation KOBOLD_CHILD_MODEL = new ModelLayerLocation(new ResourceLocation("kobolds", "kobold_child"), "main");
    private final ModelPart head;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart body;

    public KoboldChildModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.rightarm = root.m_171324_("rightarm");
        this.leftarm = root.m_171324_("leftarm");
        this.rightleg = root.m_171324_("rightleg");
        this.leftleg = root.m_171324_("leftleg");
        this.body = root.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(22, 0).m_171488_(-2.5f, -3.0f, -6.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(1, 3).m_171488_(-0.5f, -3.85f, -5.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)4.0f, (float)-0.5f));
        PartDefinition lefthorn = head.m_171599_("lefthorn", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-7.0f, (float)2.0f, (float)-0.6109f, (float)0.3054f, (float)0.1745f));
        PartDefinition righthorn = head.m_171599_("righthorn", CubeListBuilder.m_171558_().m_171514_(45, 0).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-7.0f, (float)2.0f, (float)-0.6109f, (float)-0.3054f, (float)-0.1745f));
        PartDefinition rightarm = partdefinition.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(46, 16).m_171488_(-3.0f, -0.85f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)5.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(33, 16).m_171488_(0.0f, -0.85f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)5.0f, (float)0.0f));
        PartDefinition rightleg = partdefinition.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(13, 31).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)14.0f, (float)0.0f));
        PartDefinition leftleg = partdefinition.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)14.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(3, 15).m_171488_(-3.0f, -10.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)14.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(24, 15).m_171488_(-1.0f, -3.0f, 2.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setRotateAngle(ModelPart ModelRenderer, float x, float y, float z) {
        ModelRenderer.f_104203_ = x;
        ModelRenderer.f_104204_ = y;
        ModelRenderer.f_104205_ = z;
    }

    public void setupAnim(T kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.rightarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftarm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightarm.f_104204_ = 0.0f;
        this.rightarm.f_104205_ = 0.0f;
        this.leftarm.f_104204_ = 0.0f;
        this.leftarm.f_104205_ = 0.0f;
        this.rightleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftleg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        if (this.f_102609_) {
            this.rightleg.f_104203_ = -1.5708f;
            this.leftleg.f_104203_ = -1.5708f;
            this.rightleg.f_104204_ = 0.2618f;
            this.leftleg.f_104204_ = -0.2618f;
        }
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.rightarm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.rightleg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.leftarm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.leftleg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

