/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.culinaryconstruct.api.capability.ICulinaryIngredient;
import top.theillusivec4.culinaryconstruct.client.CulinaryScreen;
import top.theillusivec4.culinaryconstruct.client.model.FoodBowlLoader;
import top.theillusivec4.culinaryconstruct.client.model.SandwichLoader;
import top.theillusivec4.culinaryconstruct.common.CulinaryConstructConfig;
import top.theillusivec4.culinaryconstruct.common.advancement.CulinaryTriggers;
import top.theillusivec4.culinaryconstruct.common.capability.CapabilityCulinaryFood;
import top.theillusivec4.culinaryconstruct.common.integration.DietIntegration;
import top.theillusivec4.culinaryconstruct.common.network.CulinaryConstructNetwork;
import top.theillusivec4.culinaryconstruct.common.registry.CulinaryConstructRegistry;

@Mod(value="culinaryconstruct")
public class CulinaryConstruct {
    public static final String MOD_ID = "culinaryconstruct";
    public static final Logger LOGGER = LogManager.getLogger();

    public CulinaryConstruct() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::config);
        eventBus.addListener(this::enqueue);
        eventBus.addListener(this::registerCaps);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CulinaryConstructConfig.serverSpec);
    }

    private void setup(FMLCommonSetupEvent evt) {
        CulinaryConstructNetwork.register();
        CapabilityCulinaryFood.register();
        CulinaryTriggers.register();
    }

    private void config(ModConfigEvent evt) {
        if (evt.getConfig().getModId().equals(MOD_ID)) {
            CulinaryConstructConfig.bake();
        }
    }

    private void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.register(ICulinaryIngredient.class);
    }

    private void enqueue(InterModEnqueueEvent evt) {
        if (ModList.get().isLoaded("diet")) {
            DietIntegration.setup();
        }
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MenuScreens.m_96206_(CulinaryConstructRegistry.CULINARY_STATION_CONTAINER, CulinaryScreen::new);
    }

    @Mod.EventBusSubscriber(modid="culinaryconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent evt) {
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(CulinaryConstruct.MOD_ID, "sandwich_loader"), (IModelLoader)SandwichLoader.INSTANCE);
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation(CulinaryConstruct.MOD_ID, "food_bowl_loader"), (IModelLoader)FoodBowlLoader.INSTANCE);
        }

        @SubscribeEvent
        public static void registerTextures(TextureStitchEvent.Pre evt) {
            TextureAtlas map = evt.getAtlas();
            if (map.m_118330_() == InventoryMenu.f_39692_) {
                for (int i = 0; i < 5; ++i) {
                    evt.addSprite(new ResourceLocation(CulinaryConstruct.MOD_ID, "item/sandwich/bread" + i));
                    evt.addSprite(new ResourceLocation(CulinaryConstruct.MOD_ID, "item/sandwich/layer" + i));
                    evt.addSprite(new ResourceLocation(CulinaryConstruct.MOD_ID, "item/bowl/layer" + i));
                }
                evt.addSprite(new ResourceLocation(CulinaryConstruct.MOD_ID, "item/bowl/liquid_base"));
                evt.addSprite(new ResourceLocation(CulinaryConstruct.MOD_ID, "item/bowl/liquid_overflow"));
            }
        }
    }
}

