/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.client.model.base;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import top.theillusivec4.culinaryconstruct.CulinaryConstruct;
import top.theillusivec4.culinaryconstruct.client.model.utils.ModelHelper;
import top.theillusivec4.culinaryconstruct.common.util.CulinaryNBTHelper;

public abstract class CulinaryOverrideHandler<T extends IModelGeometry<T>>
extends ItemOverrides {
    protected final T model;
    protected final ModelBakery bakery;
    protected final IModelConfiguration owner;
    protected final Function<Material, TextureAtlasSprite> spriteGetter;
    protected final ModelState modelTransform;
    protected final ResourceLocation modelLocation;
    private Cache<ModelHelper.CacheKey, BakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public CulinaryOverrideHandler(T model, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        this.model = model;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelLocation = modelLocation;
        this.modelTransform = modelTransform;
    }

    @Nonnull
    public BakedModel m_173464_(@Nonnull BakedModel originalModel, @Nonnull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int pSeed) {
        CompoundTag data = CulinaryNBTHelper.getTagSafe(stack);
        BakedModel output = originalModel;
        if (!data.m_128456_()) {
            ModelHelper.CacheKey key = this.getCacheKey(originalModel, stack);
            try {
                output = (BakedModel)this.bakedModelCache.get((Object)key, () -> this.getBakedModel(originalModel, stack, (Level)level, entity));
            }
            catch (ExecutionException e) {
                CulinaryConstruct.LOGGER.error("Error baking model!");
            }
        }
        return output;
    }

    protected abstract BakedModel getBakedModel(BakedModel var1, ItemStack var2, @Nullable Level var3, @Nullable LivingEntity var4);

    ModelHelper.CacheKey getCacheKey(BakedModel original, ItemStack stack) {
        return new ModelHelper.CacheKey(original, stack);
    }
}

