/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.client.model.base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;

public class PerspectiveItemModel
extends BakedItemModel {
    private ItemTransforms cameraTransforms;

    public PerspectiveItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemTransforms.TransformType, Transformation> transforms, ItemOverrides overrides, boolean untransformed, boolean isSideLit, ItemTransforms cameraTransforms) {
        super(quads, particle, transforms, overrides, untransformed, isSideLit);
        this.cameraTransforms = cameraTransforms;
    }

    @Nonnull
    public BakedModel handlePerspective(@Nonnull ItemTransforms.TransformType type, @Nonnull PoseStack mat) {
        if (this.cameraTransforms != null) {
            return ForgeHooksClient.handlePerspective((BakedModel)this, (ItemTransforms.TransformType)type, (PoseStack)mat);
        }
        return PerspectiveMapWrapper.handlePerspective((BakedModel)this, (ImmutableMap)this.transforms, (ItemTransforms.TransformType)type, (PoseStack)mat);
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    @Deprecated
    @Nonnull
    public ItemTransforms m_7442_() {
        return this.cameraTransforms;
    }
}

