/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.blockentity;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.culinaryconstruct.api.CulinaryConstructApi;
import top.theillusivec4.culinaryconstruct.api.capability.ICulinaryIngredient;
import top.theillusivec4.culinaryconstruct.common.CulinaryConstructConfig;
import top.theillusivec4.culinaryconstruct.common.item.CulinaryItemBase;
import top.theillusivec4.culinaryconstruct.common.registry.CulinaryConstructRegistry;
import top.theillusivec4.culinaryconstruct.common.tag.CulinaryTags;

public class CulinaryStationBlockEntity
extends BlockEntity {
    public final ItemStackHandler base = new CulinaryStackHandler(stack -> CulinaryTags.isBread(stack) || CulinaryTags.isBowl(stack), 1);
    public final ItemStackHandler ingredients = new CulinaryStackHandler(stack -> {
        LazyOptional<ICulinaryIngredient> culinary = CulinaryConstructApi.getCulinaryIngredient(stack);
        return !(stack.m_41720_() instanceof CulinaryItemBase) && (stack.m_41720_().m_41472_() || culinary.map(ICulinaryIngredient::isValid).orElse(false) != false) && CulinaryConstructConfig.isValidIngredient(stack);
    }, 5);
    public final ItemStackHandler output = new CulinaryStackHandler(stack -> false, 1);
    protected final LazyOptional<IItemHandler> baseOpt = LazyOptional.of(() -> this.base);
    protected final LazyOptional<IItemHandler> ingredientsOpt = LazyOptional.of(() -> this.ingredients);
    protected final LazyOptional<IItemHandler> outputOpt = LazyOptional.of(() -> this.output);

    public CulinaryStationBlockEntity(BlockPos pos, BlockState state) {
        super(CulinaryConstructRegistry.CULINARY_STATION_TE, pos, state);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("Holder", 10)) {
            this.base.deserializeNBT(compound.m_128469_("Holder"));
        }
        if (compound.m_128425_("Ingredients", 10)) {
            this.ingredients.deserializeNBT(compound.m_128469_("Ingredients"));
        }
        if (compound.m_128425_("Output", 10)) {
            this.output.deserializeNBT(compound.m_128469_("Output"));
        }
    }

    protected void m_183515_(@Nonnull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("Holder", (Tag)this.base.serializeNBT());
        pTag.m_128365_("Ingredients", (Tag)this.ingredients.serializeNBT());
        pTag.m_128365_("Output", (Tag)this.output.serializeNBT());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.baseOpt);
            }
            if (facing != Direction.DOWN) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.ingredientsOpt);
            }
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        this.baseOpt.invalidate();
        this.ingredientsOpt.invalidate();
        this.outputOpt.invalidate();
    }

    private class CulinaryStackHandler
    extends ItemStackHandler {
        private final Function<ItemStack, Boolean> validity;

        public CulinaryStackHandler(Function<ItemStack, Boolean> validity, int size) {
            super(size);
            this.validity = validity;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.validity.apply(stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CulinaryStationBlockEntity.this.m_6596_();
        }
    }
}

