/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.capability;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidAttributes;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.culinaryconstruct.api.capability.CulinaryConstructCapability;
import top.theillusivec4.culinaryconstruct.api.capability.ICulinaryIngredient;
import top.theillusivec4.culinaryconstruct.common.capability.CapabilityCulinaryFood;

public class CapabilityEventHandler {
    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        final ItemStack stack = (ItemStack)evt.getObject();
        final Item item = stack.m_41720_();
        if (item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof CakeBlock) {
            evt.addCapability(CulinaryConstructCapability.INGREDIENT_ID, CapabilityCulinaryFood.createCulinaryIngredient(new ICulinaryIngredient(){

                @Override
                public int getFoodAmount() {
                    return 14;
                }

                @Override
                public float getSaturation() {
                    return 0.2f;
                }
            }));
        } else if (item instanceof BucketItem) {
            evt.addCapability(CulinaryConstructCapability.INGREDIENT_ID, CapabilityCulinaryFood.createCulinaryIngredient(new ICulinaryIngredient(){

                @Override
                public boolean isValid() {
                    Fluid fluid = ((BucketItem)item).getFluid();
                    if (fluid == Fluids.f_76191_) {
                        return false;
                    }
                    FluidAttributes attributes = fluid.getAttributes();
                    return !attributes.isGaseous() && !attributes.isLighterThanAir() && attributes.getTemperature() <= 400;
                }

                @Override
                public boolean isLiquid() {
                    return true;
                }

                @Override
                public Integer getLiquidColor() {
                    Fluid fluid = ((BucketItem)item).getFluid();
                    if (fluid == Fluids.f_76193_) {
                        return null;
                    }
                    FluidAttributes attributes = fluid.getAttributes();
                    return attributes.getColor();
                }
            }));
        } else if (item instanceof MilkBucketItem) {
            evt.addCapability(CulinaryConstructCapability.INGREDIENT_ID, CapabilityCulinaryFood.createCulinaryIngredient(new ICulinaryIngredient(){

                @Override
                public void onEaten(Player player) {
                    if (!player.f_19853_.f_46443_) {
                        player.curePotionEffects(stack);
                    }
                }

                @Override
                public boolean isLiquid() {
                    return true;
                }

                @Override
                public Integer getLiquidColor() {
                    return 0xFFFFFF;
                }
            }));
        } else if (item instanceof PotionItem) {
            evt.addCapability(CulinaryConstructCapability.INGREDIENT_ID, CapabilityCulinaryFood.createCulinaryIngredient(new ICulinaryIngredient(){

                @Override
                public List<Pair<MobEffectInstance, Float>> getEffects() {
                    ArrayList<Pair<MobEffectInstance, Float>> list = new ArrayList<Pair<MobEffectInstance, Float>>();
                    PotionUtils.m_43547_((ItemStack)stack).forEach(effect -> list.add(Pair.of((Object)new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_()), (Object)Float.valueOf(1.0f))));
                    return list;
                }

                @Override
                public boolean isLiquid() {
                    return true;
                }

                @Override
                public Integer getLiquidColor() {
                    return PotionUtils.m_43575_((ItemStack)stack);
                }
            }));
        } else if (item instanceof SuspiciousStewItem) {
            evt.addCapability(CulinaryConstructCapability.INGREDIENT_ID, CapabilityCulinaryFood.createCulinaryIngredient(new ICulinaryIngredient(){

                @Override
                public List<Pair<MobEffectInstance, Float>> getEffects() {
                    ArrayList<Pair<MobEffectInstance, Float>> list = new ArrayList<Pair<MobEffectInstance, Float>>();
                    CompoundTag compoundnbt = stack.m_41783_();
                    if (compoundnbt != null && compoundnbt.m_128425_("Effects", 9)) {
                        ListTag listnbt = compoundnbt.m_128437_("Effects", 10);
                        for (int i = 0; i < listnbt.size(); ++i) {
                            MobEffect effect;
                            int j = 160;
                            CompoundTag compoundnbt1 = listnbt.m_128728_(i);
                            if (compoundnbt1.m_128425_("EffectDuration", 3)) {
                                j = compoundnbt1.m_128451_("EffectDuration");
                            }
                            if ((effect = MobEffect.m_19453_((int)compoundnbt1.m_128445_("EffectId"))) == null) continue;
                            list.add((Pair<MobEffectInstance, Float>)Pair.of((Object)new MobEffectInstance(effect, j), (Object)Float.valueOf(1.0f)));
                        }
                    }
                    return list;
                }
            }));
        }
    }
}

