/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public class CulinaryNBTHelper {
    public static final String TAG_BASE = "Base";
    public static final String TAG_INGREDIENTS = "Ingredients";
    public static final String TAG_FOOD = "Food";
    public static final String TAG_SATURATION = "Saturation";
    public static final String TAG_SIZE = "Size";
    public static final String TAG_QUALITY = "Quality";
    public static final String TAG_LIQUIDS = "Liquids";
    public static final String TAG_SOLIDS = "Solids";
    public static final String TAG_SOLIDS_SIZE = "SolidsSize";

    public static CompoundTag getTagSafe(ItemStack stack) {
        return stack.m_41784_();
    }

    public static ItemStack getBase(ItemStack stack) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        return ItemStack.m_41712_((CompoundTag)compound.m_128469_(TAG_BASE));
    }

    public static int getQuality(ItemStack stack) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        return compound.m_128451_(TAG_QUALITY);
    }

    public static int getSize(ItemStack stack) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        return compound.m_128451_(TAG_SIZE);
    }

    public static int getFoodAmount(ItemStack stack) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        return compound.m_128451_(TAG_FOOD);
    }

    public static float getSaturation(ItemStack stack) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        return compound.m_128457_(TAG_SATURATION);
    }

    public static NonNullList<ItemStack> getIngredientsList(ItemStack stack) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        CompoundTag tag = compound.m_128469_(TAG_INGREDIENTS);
        NonNullList list = NonNullList.m_122780_((int)CulinaryNBTHelper.getSize(stack), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)list);
        return list;
    }

    @Nullable
    public static List<Integer> getLiquids(ItemStack stack) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        if (!compound.m_128441_(TAG_LIQUIDS)) {
            return null;
        }
        ListTag tag = compound.m_128437_(TAG_LIQUIDS, 3);
        ArrayList<Integer> liquids = new ArrayList<Integer>();
        tag.forEach(nbt -> liquids.add(((IntTag)nbt).m_7047_()));
        return liquids;
    }

    public static int getSolidsSize(ItemStack stack) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        return compound.m_128451_(TAG_SOLIDS_SIZE);
    }

    public static NonNullList<ItemStack> getSolids(ItemStack stack) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        CompoundTag tag = compound.m_128469_(TAG_SOLIDS);
        NonNullList list = NonNullList.m_122780_((int)CulinaryNBTHelper.getSolidsSize(stack), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)list);
        return list;
    }

    public static void setBase(ItemStack stack, ItemStack base) {
        CulinaryNBTHelper.getTagSafe(stack).m_128365_(TAG_BASE, (Tag)base.m_41739_(new CompoundTag()));
    }

    public static void setQuality(ItemStack stack, int quality) {
        CulinaryNBTHelper.getTagSafe(stack).m_128405_(TAG_QUALITY, quality);
    }

    public static void setSize(ItemStack stack, int size) {
        CulinaryNBTHelper.getTagSafe(stack).m_128405_(TAG_SIZE, size);
    }

    public static void setFoodAmount(ItemStack stack, int food) {
        CulinaryNBTHelper.getTagSafe(stack).m_128405_(TAG_FOOD, food);
    }

    public static void setSaturation(ItemStack stack, float saturation) {
        CulinaryNBTHelper.getTagSafe(stack).m_128350_(TAG_SATURATION, saturation);
    }

    public static void setIngredientsList(ItemStack stack, NonNullList<ItemStack> ingredients) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        CompoundTag tag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)tag, ingredients);
        compound.m_128365_(TAG_INGREDIENTS, (Tag)tag);
    }

    public static void setLiquids(ItemStack stack, List<Integer> liquids) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        ListTag tag = new ListTag();
        liquids.forEach(liquid -> tag.add((Object)IntTag.m_128679_((int)liquid)));
        compound.m_128365_(TAG_LIQUIDS, (Tag)tag);
    }

    public static void setSolidsSize(ItemStack stack, int size) {
        CulinaryNBTHelper.getTagSafe(stack).m_128405_(TAG_SOLIDS_SIZE, size);
    }

    public static void setSolids(ItemStack stack, NonNullList<ItemStack> solids) {
        CompoundTag compound = CulinaryNBTHelper.getTagSafe(stack);
        CompoundTag tag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)tag, solids);
        compound.m_128365_(TAG_SOLIDS, (Tag)tag);
    }
}

