/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.input;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class KeyCodes {
    @NotNull
    public static final KeyCodes INSTANCE = new KeyCodes();
    public static final int KEY_UNKNOWN = -1;
    public static final int KEY_SPACE = 32;
    public static final int KEY_APOSTROPHE = 39;
    public static final int KEY_COMMA = 44;
    public static final int KEY_MINUS = 45;
    public static final int KEY_PERIOD = 46;
    public static final int KEY_SLASH = 47;
    public static final int KEY_0 = 48;
    public static final int KEY_1 = 49;
    public static final int KEY_2 = 50;
    public static final int KEY_3 = 51;
    public static final int KEY_4 = 52;
    public static final int KEY_5 = 53;
    public static final int KEY_6 = 54;
    public static final int KEY_7 = 55;
    public static final int KEY_8 = 56;
    public static final int KEY_9 = 57;
    public static final int KEY_SEMICOLON = 59;
    public static final int KEY_EQUAL = 61;
    public static final int KEY_A = 65;
    public static final int KEY_B = 66;
    public static final int KEY_C = 67;
    public static final int KEY_D = 68;
    public static final int KEY_E = 69;
    public static final int KEY_F = 70;
    public static final int KEY_G = 71;
    public static final int KEY_H = 72;
    public static final int KEY_I = 73;
    public static final int KEY_J = 74;
    public static final int KEY_K = 75;
    public static final int KEY_L = 76;
    public static final int KEY_M = 77;
    public static final int KEY_N = 78;
    public static final int KEY_O = 79;
    public static final int KEY_P = 80;
    public static final int KEY_Q = 81;
    public static final int KEY_R = 82;
    public static final int KEY_S = 83;
    public static final int KEY_T = 84;
    public static final int KEY_U = 85;
    public static final int KEY_V = 86;
    public static final int KEY_W = 87;
    public static final int KEY_X = 88;
    public static final int KEY_Y = 89;
    public static final int KEY_Z = 90;
    public static final int KEY_LEFT_BRACKET = 91;
    public static final int KEY_BACKSLASH = 92;
    public static final int KEY_RIGHT_BRACKET = 93;
    public static final int KEY_GRAVE_ACCENT = 96;
    public static final int KEY_WORLD_1 = 161;
    public static final int KEY_WORLD_2 = 162;
    public static final int KEY_ESCAPE = 256;
    public static final int KEY_ENTER = 257;
    public static final int KEY_TAB = 258;
    public static final int KEY_BACKSPACE = 259;
    public static final int KEY_INSERT = 260;
    public static final int KEY_DELETE = 261;
    public static final int KEY_RIGHT = 262;
    public static final int KEY_LEFT = 263;
    public static final int KEY_DOWN = 264;
    public static final int KEY_UP = 265;
    public static final int KEY_PAGE_UP = 266;
    public static final int KEY_PAGE_DOWN = 267;
    public static final int KEY_HOME = 268;
    public static final int KEY_END = 269;
    public static final int KEY_CAPS_LOCK = 280;
    public static final int KEY_SCROLL_LOCK = 281;
    public static final int KEY_NUM_LOCK = 282;
    public static final int KEY_PRINT_SCREEN = 283;
    public static final int KEY_PAUSE = 284;
    public static final int KEY_F1 = 290;
    public static final int KEY_F2 = 291;
    public static final int KEY_F3 = 292;
    public static final int KEY_F4 = 293;
    public static final int KEY_F5 = 294;
    public static final int KEY_F6 = 295;
    public static final int KEY_F7 = 296;
    public static final int KEY_F8 = 297;
    public static final int KEY_F9 = 298;
    public static final int KEY_F10 = 299;
    public static final int KEY_F11 = 300;
    public static final int KEY_F12 = 301;
    public static final int KEY_F13 = 302;
    public static final int KEY_F14 = 303;
    public static final int KEY_F15 = 304;
    public static final int KEY_F16 = 305;
    public static final int KEY_F17 = 306;
    public static final int KEY_F18 = 307;
    public static final int KEY_F19 = 308;
    public static final int KEY_F20 = 309;
    public static final int KEY_F21 = 310;
    public static final int KEY_F22 = 311;
    public static final int KEY_F23 = 312;
    public static final int KEY_F24 = 313;
    public static final int KEY_F25 = 314;
    public static final int KEY_KP_0 = 320;
    public static final int KEY_KP_1 = 321;
    public static final int KEY_KP_2 = 322;
    public static final int KEY_KP_3 = 323;
    public static final int KEY_KP_4 = 324;
    public static final int KEY_KP_5 = 325;
    public static final int KEY_KP_6 = 326;
    public static final int KEY_KP_7 = 327;
    public static final int KEY_KP_8 = 328;
    public static final int KEY_KP_9 = 329;
    public static final int KEY_KP_DECIMAL = 330;
    public static final int KEY_KP_DIVIDE = 331;
    public static final int KEY_KP_MULTIPLY = 332;
    public static final int KEY_KP_SUBTRACT = 333;
    public static final int KEY_KP_ADD = 334;
    public static final int KEY_KP_ENTER = 335;
    public static final int KEY_KP_EQUAL = 336;
    public static final int KEY_LEFT_SHIFT = 340;
    public static final int KEY_LEFT_CONTROL = 341;
    public static final int KEY_LEFT_ALT = 342;
    public static final int KEY_LEFT_SUPER = 343;
    public static final int KEY_RIGHT_SHIFT = 344;
    public static final int KEY_RIGHT_CONTROL = 345;
    public static final int KEY_RIGHT_ALT = 346;
    public static final int KEY_RIGHT_SUPER = 347;
    public static final int KEY_MENU = 348;
    public static final int KEY_LAST = 348;
    public static final int MOUSE_BUTTON_1 = -100;
    public static final int MOUSE_BUTTON_2 = -99;
    public static final int MOUSE_BUTTON_3 = -98;
    public static final int MOUSE_BUTTON_4 = -97;
    public static final int MOUSE_BUTTON_5 = -96;
    public static final int MOUSE_BUTTON_6 = -95;
    public static final int MOUSE_BUTTON_7 = -94;
    public static final int MOUSE_BUTTON_8 = -93;
    @NotNull
    private static final Map MAP_KEY_CODE_TO_NAME = new LinkedHashMap();
    @NotNull
    private static final Map MAP_NAME_TO_KEY_CODE = new LinkedHashMap();
    @NotNull
    private static final Map MAP_NAME_TO_DISPLAY_TEXT = new LinkedHashMap();
    @NotNull
    private static final Map MODIFIER_KEY_CODES = new LinkedHashMap();
    @NotNull
    private static final Map MODIFIER_DISPLAY_TEXTS = new LinkedHashMap();

    private KeyCodes() {
    }

    @NotNull
    public final String getName(int n2) {
        return MAP_KEY_CODE_TO_NAME.getOrDefault(n2, "keycode ".concat(String.valueOf(n2)));
    }

    public final int getKeyCode(@NotNull String string) {
        return ((Number)MAP_NAME_TO_KEY_CODE.getOrDefault(string, -1)).intValue();
    }

    @NotNull
    public final String getFriendlyName(@NotNull String string) {
        String string2 = string;
        return MAP_NAME_TO_DISPLAY_TEXT.getOrDefault(string2, string2);
    }

    @NotNull
    public final String getFriendlyName(int n2) {
        KeyCodes keyCodes = this;
        return keyCodes.getFriendlyName(keyCodes.getName(n2));
    }

    @NotNull
    public final Set getModifiers() {
        return MODIFIER_KEY_CODES.keySet();
    }

    @NotNull
    public final String getModifierName(int n2) {
        Map map = MODIFIER_DISPLAY_TEXTS;
        Object object = map.get(n2);
        if (object == null) {
            object = INSTANCE.getFriendlyName(n2);
        }
        return (String)object;
    }

    public final int getModifierKeyCode(int n2) {
        return ((Number)MODIFIER_KEY_CODES.getOrDefault(n2, n2)).intValue();
    }

    private final void addEntry(String string, String string2, int n2) {
        Object object;
        Map map = MAP_KEY_CODE_TO_NAME;
        Integer n3 = n2;
        if (map.get(n3) == null) {
            object = string;
            map.put(n3, object);
        }
        if ((map = MAP_NAME_TO_KEY_CODE).get(string) == null) {
            object = n2;
            map.put(string, object);
        }
        if ((map = MAP_NAME_TO_DISPLAY_TEXT).get(string) == null) {
            object = string2;
            string2 = object == null || object.length() == 0 ? string : string2;
            map.put(string, string2);
        }
    }

    private final void addModifier(String string, int n2, int ... nArray) {
        Integer n3;
        int n4 = nArray.length;
        int[] nArray2 = Arrays.copyOf(nArray, n4 + 1);
        nArray = nArray2;
        nArray2[n4] = n2;
        int[] nArray3 = nArray;
        int n5 = nArray3.length;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray3[n4];
            Integer n6 = n2;
            MODIFIER_KEY_CODES.put(n3, n6);
        }
        nArray3 = nArray;
        n5 = nArray3.length;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray3[n4];
            MODIFIER_DISPLAY_TEXTS.put(n3, string);
        }
    }

    static {
        INSTANCE.addEntry("UNKNOWN", null, -1);
        INSTANCE.addEntry("SPACE", "Space", 32);
        INSTANCE.addEntry("APOSTROPHE", "'", 39);
        INSTANCE.addEntry("COMMA", ",", 44);
        INSTANCE.addEntry("MINUS", "-", 45);
        INSTANCE.addEntry("PERIOD", ".", 46);
        INSTANCE.addEntry("SLASH", "/", 47);
        INSTANCE.addEntry("0", "0", 48);
        INSTANCE.addEntry("1", "1", 49);
        INSTANCE.addEntry("2", "2", 50);
        INSTANCE.addEntry("3", "3", 51);
        INSTANCE.addEntry("4", "4", 52);
        INSTANCE.addEntry("5", "5", 53);
        INSTANCE.addEntry("6", "6", 54);
        INSTANCE.addEntry("7", "7", 55);
        INSTANCE.addEntry("8", "8", 56);
        INSTANCE.addEntry("9", "9", 57);
        INSTANCE.addEntry("SEMICOLON", ";", 59);
        INSTANCE.addEntry("EQUAL", "=", 61);
        INSTANCE.addEntry("A", "a", 65);
        INSTANCE.addEntry("B", "b", 66);
        INSTANCE.addEntry("C", "c", 67);
        INSTANCE.addEntry("D", "d", 68);
        INSTANCE.addEntry("E", "e", 69);
        INSTANCE.addEntry("F", "f", 70);
        INSTANCE.addEntry("G", "g", 71);
        INSTANCE.addEntry("H", "h", 72);
        INSTANCE.addEntry("I", "i", 73);
        INSTANCE.addEntry("J", "j", 74);
        INSTANCE.addEntry("K", "k", 75);
        INSTANCE.addEntry("L", "l", 76);
        INSTANCE.addEntry("M", "m", 77);
        INSTANCE.addEntry("N", "n", 78);
        INSTANCE.addEntry("O", "o", 79);
        INSTANCE.addEntry("P", "p", 80);
        INSTANCE.addEntry("Q", "q", 81);
        INSTANCE.addEntry("R", "r", 82);
        INSTANCE.addEntry("S", "s", 83);
        INSTANCE.addEntry("T", "t", 84);
        INSTANCE.addEntry("U", "u", 85);
        INSTANCE.addEntry("V", "v", 86);
        INSTANCE.addEntry("W", "w", 87);
        INSTANCE.addEntry("X", "x", 88);
        INSTANCE.addEntry("Y", "y", 89);
        INSTANCE.addEntry("Z", "z", 90);
        INSTANCE.addEntry("LEFT_BRACKET", "[", 91);
        INSTANCE.addEntry("BACKSLASH", "\\", 92);
        INSTANCE.addEntry("RIGHT_BRACKET", "]", 93);
        INSTANCE.addEntry("GRAVE_ACCENT", "`", 96);
        INSTANCE.addEntry("WORLD_1", null, 161);
        INSTANCE.addEntry("WORLD_2", null, 162);
        INSTANCE.addEntry("ESCAPE", "Esc", 256);
        INSTANCE.addEntry("ENTER", "Enter", 257);
        INSTANCE.addEntry("TAB", "Tab", 258);
        INSTANCE.addEntry("BACKSPACE", "Backspace", 259);
        INSTANCE.addEntry("INSERT", "Insert", 260);
        INSTANCE.addEntry("DELETE", "Delete", 261);
        INSTANCE.addEntry("RIGHT", "Right", 262);
        INSTANCE.addEntry("LEFT", "Left", 263);
        INSTANCE.addEntry("DOWN", "Down", 264);
        INSTANCE.addEntry("UP", "Up", 265);
        INSTANCE.addEntry("PAGE_UP", "Page Up", 266);
        INSTANCE.addEntry("PAGE_DOWN", "Page Down", 267);
        INSTANCE.addEntry("HOME", "Home", 268);
        INSTANCE.addEntry("END", "End", 269);
        INSTANCE.addEntry("CAPS_LOCK", "Caps Lock", 280);
        INSTANCE.addEntry("SCROLL_LOCK", "Scroll Lock", 281);
        INSTANCE.addEntry("NUM_LOCK", "Num Lock", 282);
        INSTANCE.addEntry("PRINT_SCREEN", "Print Screen", 283);
        INSTANCE.addEntry("PAUSE", "Pause", 284);
        INSTANCE.addEntry("F1", "F1", 290);
        INSTANCE.addEntry("F2", "F2", 291);
        INSTANCE.addEntry("F3", "F3", 292);
        INSTANCE.addEntry("F4", "F4", 293);
        INSTANCE.addEntry("F5", "F5", 294);
        INSTANCE.addEntry("F6", "F6", 295);
        INSTANCE.addEntry("F7", "F7", 296);
        INSTANCE.addEntry("F8", "F8", 297);
        INSTANCE.addEntry("F9", "F9", 298);
        INSTANCE.addEntry("F10", "F10", 299);
        INSTANCE.addEntry("F11", "F11", 300);
        INSTANCE.addEntry("F12", "F12", 301);
        INSTANCE.addEntry("F13", null, 302);
        INSTANCE.addEntry("F14", null, 303);
        INSTANCE.addEntry("F15", null, 304);
        INSTANCE.addEntry("F16", null, 305);
        INSTANCE.addEntry("F17", null, 306);
        INSTANCE.addEntry("F18", null, 307);
        INSTANCE.addEntry("F19", null, 308);
        INSTANCE.addEntry("F20", null, 309);
        INSTANCE.addEntry("F21", null, 310);
        INSTANCE.addEntry("F22", null, 311);
        INSTANCE.addEntry("F23", null, 312);
        INSTANCE.addEntry("F24", null, 313);
        INSTANCE.addEntry("F25", null, 314);
        INSTANCE.addEntry("KP_0", "Numpad 0", 320);
        INSTANCE.addEntry("KP_1", "Numpad 1", 321);
        INSTANCE.addEntry("KP_2", "Numpad 2", 322);
        INSTANCE.addEntry("KP_3", "Numpad 3", 323);
        INSTANCE.addEntry("KP_4", "Numpad 4", 324);
        INSTANCE.addEntry("KP_5", "Numpad 5", 325);
        INSTANCE.addEntry("KP_6", "Numpad 6", 326);
        INSTANCE.addEntry("KP_7", "Numpad 7", 327);
        INSTANCE.addEntry("KP_8", "Numpad 8", 328);
        INSTANCE.addEntry("KP_9", "Numpad 9", 329);
        INSTANCE.addEntry("KP_DECIMAL", "Numpad .", 330);
        INSTANCE.addEntry("KP_DIVIDE", "Numpad /", 331);
        INSTANCE.addEntry("KP_MULTIPLY", "Numpad *", 332);
        INSTANCE.addEntry("KP_SUBTRACT", "Numpad -", 333);
        INSTANCE.addEntry("KP_ADD", "Numpad +", 334);
        INSTANCE.addEntry("KP_ENTER", "Numpad Enter", 335);
        INSTANCE.addEntry("KP_EQUAL", null, 336);
        INSTANCE.addEntry("LEFT_SHIFT", "Left Shift", 340);
        INSTANCE.addEntry("LEFT_CONTROL", "Left Ctrl", 341);
        INSTANCE.addEntry("LEFT_ALT", "Left Alt", 342);
        INSTANCE.addEntry("LEFT_SUPER", "Left Win", 343);
        INSTANCE.addEntry("RIGHT_SHIFT", "Right Shift", 344);
        INSTANCE.addEntry("RIGHT_CONTROL", "Right Ctrl", 345);
        INSTANCE.addEntry("RIGHT_ALT", "Right Alt", 346);
        INSTANCE.addEntry("RIGHT_SUPER", "Right Win", 347);
        INSTANCE.addEntry("MENU", "Menu", 348);
        INSTANCE.addEntry("LAST", null, 348);
        INSTANCE.addEntry("BUTTON_1", "Left Button", -100);
        INSTANCE.addEntry("BUTTON_2", "Right Button", -99);
        INSTANCE.addEntry("BUTTON_3", "Middle Button", -98);
        INSTANCE.addEntry("BUTTON_4", "Back Button", -97);
        INSTANCE.addEntry("BUTTON_5", "Forward Button", -96);
        INSTANCE.addEntry("BUTTON_6", null, -95);
        INSTANCE.addEntry("BUTTON_7", null, -94);
        INSTANCE.addEntry("BUTTON_8", null, -93);
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 344;
        INSTANCE.addModifier("Shift", 340, nArray2);
        int[] nArray3 = new int[1];
        nArray2 = nArray3;
        nArray3[0] = 345;
        INSTANCE.addModifier("Ctrl", 341, nArray2);
        int[] nArray4 = new int[1];
        nArray2 = nArray4;
        nArray4[0] = 346;
        INSTANCE.addModifier("Alt", 342, nArray2);
        int[] nArray5 = new int[1];
        nArray2 = nArray5;
        nArray5[0] = 347;
        INSTANCE.addModifier("Win", 343, nArray2);
    }
}

