/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.math2d;

import org.anti_ad.mc.common.math2d.Rect2dKt;
import org.anti_ad.mc.common.math2d.Size;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Point {
    private final int x;
    private final int y;

    public Point(int n2, int n3) {
        this.x = n2;
        this.y = n3;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    @NotNull
    public final Point unaryPlus() {
        return this;
    }

    @NotNull
    public final Point unaryMinus() {
        return new Point(-this.x, -this.y);
    }

    @NotNull
    public final Point minus(@NotNull Size size) {
        return this.minus(Rect2dKt.toPoint(size));
    }

    @NotNull
    public final Point minus(@NotNull Point point) {
        return this.plus(point.unaryMinus());
    }

    @NotNull
    public final Point plus(@NotNull Size size) {
        return this.plus(Rect2dKt.toPoint(size));
    }

    @NotNull
    public final Point plus(@NotNull Point point) {
        return new Point(this.x + point.x, this.y + point.y);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    @NotNull
    public final Point copy(int n2, int n3) {
        return new Point(n2, n3);
    }

    public static /* synthetic */ Point copy$default(Point point, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = point.x;
        }
        if ((n4 & 2) != 0) {
            n3 = point.y;
        }
        return point.copy(n2, n3);
    }

    @NotNull
    public final String toString() {
        return "Point(x=" + this.x + ", y=" + this.y + ')';
    }

    public final int hashCode() {
        return Integer.hashCode(this.x) * 31 + Integer.hashCode(this.y);
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Point)) {
            return false;
        }
        object = (Point)object;
        if (this.x != ((Point)object).x) {
            return false;
        }
        return this.y == ((Point)object).y;
    }
}

