/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.util;

import java.util.LinkedHashSet;
import java.util.Set;
import org.anti_ad.a.a.f.b.D;
import org.anti_ad.mc.common.Log;
import org.anti_ad.mc.common.util.Node$dumpWidgetTree$1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Node {
    private final Object value;
    @Nullable
    private Node mParent;
    @NotNull
    private final Set mChildren;

    public Node(Object object) {
        this.value = object;
        this.mChildren = new LinkedHashSet();
    }

    public final Object getValue() {
        return this.value;
    }

    @Nullable
    public final Node getParent() {
        return this.mParent;
    }

    public final void setParent(@Nullable Node node) {
        Node node2 = node;
        if (node2 != null) {
            node2.add(this);
            return;
        }
        Node node3 = this.mParent;
        if (node3 != null) {
            node3.remove(this);
            return;
        }
    }

    @NotNull
    public final Set getChildren() {
        return this.mChildren;
    }

    public final boolean deepContains(@NotNull Node node) {
        while (!D.a(this, (Object)node)) {
            if (node.mParent != null) continue;
            return false;
        }
        return true;
    }

    public final void add(@NotNull Node node) {
        if (node.deepContains(this)) {
            Log.INSTANCE.error("The new child node contains the parent");
            return;
        }
        Node node2 = node.mParent;
        if (node2 != null) {
            node2.remove(node);
        }
        this.mChildren.add(node);
        node.mParent = this;
    }

    public final void remove(@NotNull Node node) {
        if (this.mChildren.remove(node)) {
            node.mParent = null;
        }
    }

    public final void dumpWidgetTree() {
        Log.INSTANCE.trace(new Node$dumpWidgetTree$1(this));
        for (Node node : (Iterable)this.mChildren) {
            Log.INSTANCE.indent();
            node.dumpWidgetTree();
            Log.INSTANCE.unindent();
        }
    }
}

