/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.vanilla.render.glue;

import java.util.List;
import org.anti_ad.mc.common.math2d.ExtKt;
import org.anti_ad.mc.common.math2d.Rectangle;
import org.anti_ad.mc.common.math2d.Size;
import org.anti_ad.mc.common.vanilla.render.glue.IdentifierHolder;
import org.anti_ad.mc.common.vanilla.render.glue.Sprite;
import org.anti_ad.mc.common.vanilla.render.glue.TextureKt;
import org.jetbrains.annotations.NotNull;

public final class DynamicSizeSprite {
    @NotNull
    private final Sprite sprite;
    @NotNull
    private final List clips;

    public DynamicSizeSprite(@NotNull Sprite sprite, @NotNull Rectangle rectangle) {
        this.sprite = sprite;
        this.clips = ExtKt.split3x3(this.sprite.getSpriteBounds(), rectangle);
    }

    public DynamicSizeSprite(@NotNull Sprite sprite, int n2) {
        Sprite sprite2 = sprite;
        this(sprite2, sprite2.getSpriteBounds().inflated(-n2));
    }

    @NotNull
    public final List getClips() {
        return this.clips;
    }

    @NotNull
    public final IdentifierHolder getIdentifier() {
        return this.sprite.getIdentifier();
    }

    @NotNull
    public final Size getTextureSize() {
        return this.sprite.getTextureSize();
    }

    private final Rectangle getCenterBounds() {
        return (Rectangle)this.clips.get(5);
    }

    @NotNull
    public final Size getCornerSize() {
        return ((Rectangle)this.clips.get(0)).getSize().minus(((Rectangle)this.clips.get(5)).getSize());
    }

    private final Rectangle getCenterBounds(Rectangle rectangle) {
        return TextureKt.access$relativeBounds(this.getCenterBounds(), this.sprite.getSpriteBounds().getLocation(), rectangle.getLocation());
    }

    private final DynamicSizeSprite getDynamic(Sprite sprite) {
        return new DynamicSizeSprite(sprite, this.getCenterBounds(sprite.getSpriteBounds()));
    }

    @NotNull
    public final DynamicSizeSprite left(double d2) {
        DynamicSizeSprite dynamicSizeSprite = this;
        return dynamicSizeSprite.getDynamic(dynamicSizeSprite.sprite.left(d2));
    }

    @NotNull
    public final DynamicSizeSprite right(double d2) {
        DynamicSizeSprite dynamicSizeSprite = this;
        return dynamicSizeSprite.getDynamic(dynamicSizeSprite.sprite.right(d2));
    }

    @NotNull
    public final DynamicSizeSprite up(double d2) {
        DynamicSizeSprite dynamicSizeSprite = this;
        return dynamicSizeSprite.getDynamic(dynamicSizeSprite.sprite.up(d2));
    }

    @NotNull
    public final DynamicSizeSprite down(double d2) {
        DynamicSizeSprite dynamicSizeSprite = this;
        return dynamicSizeSprite.getDynamic(dynamicSizeSprite.sprite.down(d2));
    }

    @NotNull
    public final DynamicSizeSprite left(int n2) {
        return this.left((double)n2);
    }

    public static /* synthetic */ DynamicSizeSprite left$default(DynamicSizeSprite dynamicSizeSprite, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 1;
        }
        return dynamicSizeSprite.left(n2);
    }

    @NotNull
    public final DynamicSizeSprite right(int n2) {
        return this.right((double)n2);
    }

    public static /* synthetic */ DynamicSizeSprite right$default(DynamicSizeSprite dynamicSizeSprite, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 1;
        }
        return dynamicSizeSprite.right(n2);
    }

    @NotNull
    public final DynamicSizeSprite up(int n2) {
        return this.up((double)n2);
    }

    public static /* synthetic */ DynamicSizeSprite up$default(DynamicSizeSprite dynamicSizeSprite, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 1;
        }
        return dynamicSizeSprite.up(n2);
    }

    @NotNull
    public final DynamicSizeSprite down(int n2) {
        return this.down((double)n2);
    }

    public static /* synthetic */ DynamicSizeSprite down$default(DynamicSizeSprite dynamicSizeSprite, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 1;
        }
        return dynamicSizeSprite.down(n2);
    }
}

