/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.vanilla.render.glue;

import org.anti_ad.a.a.f.b.D;
import org.anti_ad.mc.common.math2d.ExtKt;
import org.anti_ad.mc.common.math2d.Rectangle;
import org.anti_ad.mc.common.math2d.Size;
import org.anti_ad.mc.common.vanilla.render.glue.IdentifierHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Sprite {
    @NotNull
    private final IdentifierHolder identifier;
    @NotNull
    private final Size textureSize;
    @NotNull
    private final Rectangle spriteBounds;

    public Sprite(@NotNull IdentifierHolder identifierHolder, @NotNull Size size, @NotNull Rectangle rectangle) {
        this.identifier = identifierHolder;
        this.textureSize = size;
        this.spriteBounds = rectangle;
    }

    @NotNull
    public final IdentifierHolder getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final Size getTextureSize() {
        return this.textureSize;
    }

    @NotNull
    public final Rectangle getSpriteBounds() {
        return this.spriteBounds;
    }

    public Sprite(@NotNull IdentifierHolder identifierHolder, @NotNull Rectangle rectangle) {
        this(identifierHolder, new Size(256, 256), rectangle);
    }

    @NotNull
    public final Size getSize() {
        return this.spriteBounds.getSize();
    }

    @NotNull
    public final Sprite left(double d2) {
        return this.right(-d2);
    }

    @NotNull
    public final Sprite right(double d2) {
        return Sprite.copy$default(this, null, null, ExtKt.repeatX(this.spriteBounds, d2), 3, null);
    }

    @NotNull
    public final Sprite up(double d2) {
        return this.down(-d2);
    }

    @NotNull
    public final Sprite down(double d2) {
        return Sprite.copy$default(this, null, null, ExtKt.repeatY(this.spriteBounds, d2), 3, null);
    }

    @NotNull
    public final Sprite left(int n2) {
        return this.left((double)n2);
    }

    public static /* synthetic */ Sprite left$default(Sprite sprite, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 1;
        }
        return sprite.left(n2);
    }

    @NotNull
    public final Sprite right(int n2) {
        return this.right((double)n2);
    }

    public static /* synthetic */ Sprite right$default(Sprite sprite, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 1;
        }
        return sprite.right(n2);
    }

    @NotNull
    public final Sprite up(int n2) {
        return this.up((double)n2);
    }

    public static /* synthetic */ Sprite up$default(Sprite sprite, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 1;
        }
        return sprite.up(n2);
    }

    @NotNull
    public final Sprite down(int n2) {
        return this.down((double)n2);
    }

    public static /* synthetic */ Sprite down$default(Sprite sprite, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 1;
        }
        return sprite.down(n2);
    }

    @NotNull
    public final IdentifierHolder component1() {
        return this.identifier;
    }

    @NotNull
    public final Size component2() {
        return this.textureSize;
    }

    @NotNull
    public final Rectangle component3() {
        return this.spriteBounds;
    }

    @NotNull
    public final Sprite copy(@NotNull IdentifierHolder identifierHolder, @NotNull Size size, @NotNull Rectangle rectangle) {
        return new Sprite(identifierHolder, size, rectangle);
    }

    public static /* synthetic */ Sprite copy$default(Sprite sprite, IdentifierHolder identifierHolder, Size size, Rectangle rectangle, int n2, Object object) {
        if ((n2 & 1) != 0) {
            identifierHolder = sprite.identifier;
        }
        if ((n2 & 2) != 0) {
            size = sprite.textureSize;
        }
        if ((n2 & 4) != 0) {
            rectangle = sprite.spriteBounds;
        }
        return sprite.copy(identifierHolder, size, rectangle);
    }

    @NotNull
    public final String toString() {
        return "Sprite(identifier=" + this.identifier + ", textureSize=" + this.textureSize + ", spriteBounds=" + this.spriteBounds + ')';
    }

    public final int hashCode() {
        return (this.identifier.hashCode() * 31 + this.textureSize.hashCode()) * 31 + this.spriteBounds.hashCode();
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Sprite)) {
            return false;
        }
        object = (Sprite)object;
        if (!D.a(this.identifier, (Object)((Sprite)object).identifier)) {
            return false;
        }
        if (!D.a(this.textureSize, (Object)((Sprite)object).textureSize)) {
            return false;
        }
        return D.a(this.spriteBounds, (Object)((Sprite)object).spriteBounds);
    }
}

