/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.inventory.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.anti_ad.mc.ipnext.inventory.data.ItemBucket;
import org.anti_ad.mc.ipnext.item.ItemStack;
import org.anti_ad.mc.ipnext.item.ItemType;
import org.anti_ad.mc.ipnext.item.ItemTypeExtensionsKt;
import org.anti_ad.mc.ipnext.util.MutableBucket;
import org.jetbrains.annotations.NotNull;

public final class MutableItemBucket
extends MutableBucket
implements ItemBucket {
    private MutableItemBucket(Map map) {
        super(map);
    }

    public MutableItemBucket() {
    }

    protected final boolean validateEmpty(@NotNull ItemType itemType) {
        return ItemTypeExtensionsKt.isEmpty(itemType);
    }

    public final boolean add(@NotNull ItemStack itemStack) {
        return this.add(itemStack.getItemType(), itemStack.getCount());
    }

    public final void addAll(@NotNull List object) {
        for (ItemStack itemStack : (Iterable)object) {
            this.add(itemStack);
        }
    }

    @Override
    public final boolean contains(@NotNull ItemStack itemStack) {
        return this.contains(itemStack.getItemType(), itemStack.getCount());
    }

    @Override
    public final boolean containsAll(@NotNull List object) {
        if (!((object = (Iterable)object) instanceof Collection) || !((Collection)object).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                ItemStack itemStack = (ItemStack)object.next();
                if (this.contains(itemStack)) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean remove(@NotNull ItemStack itemStack) {
        return this.remove(itemStack.getItemType(), itemStack.getCount());
    }

    public final void removeAll(@NotNull List object) {
        for (ItemStack itemStack : (Iterable)object) {
            this.remove(itemStack);
        }
    }

    @Override
    @NotNull
    public final ItemBucket minus(@NotNull ItemBucket itemBucket) {
        MutableItemBucket mutableItemBucket = this.copyAsMutable();
        mutableItemBucket.removeAll(itemBucket);
        return mutableItemBucket;
    }

    @Override
    @NotNull
    public final ItemBucket copy() {
        return this.copyAsMutable();
    }

    @Override
    @NotNull
    public final MutableItemBucket copyAsMutable() {
        return new MutableItemBucket(this.getAsMap());
    }

    @NotNull
    public final String toString() {
        Object object;
        Object object2 = object = this.getAsMap();
        object = new ArrayList(object.size());
        for (Map.Entry entry : object2.entrySet()) {
            Object object3 = object;
            object3.add(ItemStack.Companion.invoke((ItemType)entry.getKey(), ((Number)entry.getValue()).intValue()));
        }
        return ((List)object).toString();
    }
}

