/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.inventory.sandbox.diffcalculator;

import org.anti_ad.mc.common.Log;
import org.anti_ad.mc.common.annotation.MayThrow;
import org.anti_ad.mc.ipnext.inventory.data.ItemTracker;
import org.anti_ad.mc.ipnext.inventory.sandbox.ContainerSandbox;
import org.anti_ad.mc.ipnext.inventory.sandbox.diffcalculator.GenericDiffCalculatorInstance;
import org.jetbrains.annotations.NotNull;

public final class DiffCalculator {
    @NotNull
    public static final DiffCalculator INSTANCE = new DiffCalculator();

    private DiffCalculator() {
    }

    @MayThrow
    public final void apply(@NotNull ContainerSandbox containerSandbox, @NotNull ItemTracker itemTracker) {
        long l2 = System.nanoTime();
        try {
            new GenericDiffCalculatorInstance(containerSandbox, itemTracker).run();
            return;
        }
        finally {
            long l3 = System.nanoTime() - l2;
            Log.INSTANCE.debug("diff brain costs " + (double)l3 / 1000000.0 + " ms");
        }
    }
}

