/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.anvil;

import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.config.Constants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class SmithingRecipeCategory
implements IRecipeCategory<UpgradeRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public SmithingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 168, 125, 18);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, new ItemStack((ItemLike)Blocks.f_50625_));
    }

    @Override
    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    @Override
    public Class<? extends UpgradeRecipe> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    @Override
    public RecipeType<UpgradeRecipe> getRecipeType() {
        return RecipeTypes.SMITHING;
    }

    @Override
    public Component getTitle() {
        return Blocks.f_50625_.m_49954_();
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, UpgradeRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.f_44518_);
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients(recipe.f_44519_);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStack(recipe.m_8043_());
    }

    @Override
    public boolean isHandled(UpgradeRecipe recipe) {
        return !recipe.m_5598_();
    }
}

