/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobWithTypesBucketable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityJellyfish
extends EntityWaterMobWithTypesBucketable {
    protected static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(EntityJellyfish.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected int attackCooldown = 0;
    public float jellyYaw;
    public float prevJellyYaw;
    public float jellyRotation;
    public float prevJellyRotation;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public EntityJellyfish(EntityType<? extends EntityJellyfish> entityType, Level worldIn) {
        super((EntityType<? extends EntityWaterMobWithTypesBucketable>)entityType, worldIn);
        this.setSize(0.8f);
        this.rotationVelocity = 1.0f / (this.f_19796_.nextFloat() + 1.0f) * 0.2f;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AIMoveRandom(this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.prevJellyYaw = this.jellyYaw;
        this.prevJellyRotation = this.jellyRotation;
        this.jellyRotation += this.rotationVelocity;
        if ((double)this.jellyRotation > Math.PI * 2) {
            if (this.f_19853_.f_46443_) {
                this.jellyRotation = (float)Math.PI * 2;
            } else {
                this.jellyRotation = (float)((double)this.jellyRotation - Math.PI * 2);
                if (this.f_19796_.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.f_19796_.nextFloat() + 1.0f) * 0.2f;
                }
                this.f_19853_.m_7605_((Entity)this, (byte)19);
            }
        }
        if (this.m_20072_()) {
            if (this.jellyRotation < (float)Math.PI) {
                float lvt_1_1_ = this.jellyRotation / (float)Math.PI;
                if ((double)lvt_1_1_ > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.f_19853_.f_46443_) {
                this.m_20334_(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            this.f_20883_ += (-((float)Mth.m_14136_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7094_())) * 57.295776f - this.f_20883_) * 0.1f;
            this.m_146922_(this.f_20883_);
            this.jellyYaw = (float)((double)this.jellyYaw + Math.PI * (double)this.rotateSpeed * 1.5);
        } else if (!this.f_19853_.f_46443_) {
            this.m_20334_(0.0, this.m_20184_().m_7098_(), 0.0);
            if (this.m_21023_(MobEffects.f_19620_)) {
                this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() + 0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - this.m_20184_().m_7098_(), this.m_20184_().m_7094_());
            } else if (!this.m_20068_()) {
                this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() - 0.08, this.m_20184_().m_7094_());
            }
            this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() * (double)0.98f, this.m_20184_().m_7094_());
        }
    }

    public void m_6123_(Player entity) {
        super.m_6123_(entity);
        if (!entity.m_7500_() && this.attackCooldown == 0 && entity.f_19853_.m_46791_() != Difficulty.PEACEFUL) {
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.0f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0, false, false));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 90, 2, false, false));
            this.attackCooldown = 80;
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12388_;
    }

    public void m_7023_(Vec3 vec) {
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 19) {
            this.jellyRotation = 0.0f;
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    public void setMovementVector(float p_175568_1_, float p_175568_2_, float p_175568_3_) {
        this.randomMotionVecX = p_175568_1_;
        this.randomMotionVecY = p_175568_2_;
        this.randomMotionVecZ = p_175568_3_;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
    }

    public EntityDimensions m_6972_(Pose pose) {
        float size = ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
        return EntityDimensions.m_20395_((float)size, (float)size).m_20388_(this.m_6134_());
    }

    public void setSize(float size) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Size", this.m_6972_((Pose)Pose.STANDING).f_20377_);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        float size = compound.m_128457_("Size");
        this.setSize(size);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        livingdata = super.m_6518_(world, difficulty, reason, livingdata, compound);
        if (!this.m_6162_()) {
            String i = this.getRandomType().getName();
            float rand = ((float)this.f_19796_.nextInt(30) + 1.0f) / 50.0f + 0.05f;
            if (livingdata instanceof JellyfishData) {
                i = ((JellyfishData)livingdata).typeData;
                rand = ((JellyfishData)livingdata).size;
            } else {
                livingdata = new JellyfishData(i, rand);
            }
            this.setType(i);
            this.setSize(rand);
        }
        return livingdata;
    }

    @Override
    public EntityJellyfish getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<EntityJellyfish> getContainer() {
        return ModEntities.JELLYFISH;
    }

    @Override
    public void setContainerData(ItemStack bucket) {
        super.setContainerData(bucket);
        CompoundTag tag = bucket.m_41783_();
        tag.m_128350_("JellyfishSizeTag", ((Float)this.f_19804_.m_135370_(SIZE)).floatValue());
        bucket.m_41751_(tag);
    }

    @Override
    public void readFromContainerTag(CompoundTag tag) {
        super.readFromContainerTag(tag);
        if (tag.m_128441_("JellyfishSizeTag")) {
            this.setSize(tag.m_128457_("JellyfishSizeTag"));
        }
    }

    public static void bucketTooltip(EntityTypeContainer<? extends Mob> container, ItemStack stack, Level worldIn, List<Component> tooltip) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("JellyfishSizeTag", 5)) {
            tooltip.add((Component)new TextComponent("Size: " + tag.m_128457_("JellyfishSizeTag")).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public EntityTypeContainerContainable<?, ?> getContainableContainer() {
        return ModEntities.JELLYFISH;
    }

    static class AIMoveRandom
    extends Goal {
        private final EntityJellyfish entity;

        public AIMoveRandom(EntityJellyfish entityIn) {
            this.entity = entityIn;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            int i = this.entity.m_21216_();
            if (i > 100) {
                this.entity.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.entity.m_21187_().nextInt(50) == 0 || !this.entity.f_19798_ || !this.entity.hasMovementVector()) {
                float f = this.entity.m_21187_().nextFloat() * ((float)Math.PI * 2);
                float f1 = Mth.m_14089_((float)f) * 0.2f;
                float f2 = -0.1f + this.entity.m_21187_().nextFloat() * 0.2f;
                float f3 = Mth.m_14031_((float)f) * 0.2f;
                this.entity.setMovementVector(f1 / 3.0f, f2 / 3.0f, f3 / 3.0f);
            }
        }
    }

    public static class JellyfishData
    implements SpawnGroupData {
        public String typeData;
        public float size;

        public JellyfishData(String type, float size) {
            this.typeData = type;
            this.size = size;
        }
    }
}

