/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.ai.EntityAIFollowOwnerFlying;
import dev.itsmeow.betteranimalsplus.common.entity.ai.LammerMoveHelper;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityTypeContainerBAPTameable;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityTameableBetterAnimalsPlus;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityTameableFlyingWithTypes;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityTameableWithTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.util.ModPlatformEvents;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;

public class EntityLammergeier
extends EntityTameableFlyingWithTypes
implements IVariantTypes<EntityTameableBetterAnimalsPlus> {
    protected static final EntityDataAccessor<Float> DATA_HEALTH_ID = SynchedEntityData.m_135353_(EntityLammergeier.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected boolean readyToSit = false;
    public float lastRotX = 0.0f;
    public float rotX = 0.0f;
    private int lastTick = 0;
    public double lastMotionY = 0.0;
    private final MoveControl flightControl;

    public EntityLammergeier(EntityType<? extends EntityLammergeier> entityType, Level worldIn) {
        super((EntityType<? extends EntityTameableFlyingWithTypes>)entityType, worldIn);
        this.f_21342_ = this.flightControl = new LammerMoveHelper(this);
    }

    public int m_5792_() {
        return 2;
    }

    public boolean m_6094_() {
        return super.m_6094_() && this.m_20197_().size() != 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new AIMeleeAttack(this));
        this.f_21345_.m_25352_(3, (Goal)new EntityAIFollowOwnerFlying(this, 2.0, 8.0f, 50.0f){

            @Override
            public void m_8056_() {
                if (!EntityLammergeier.this.getFlying()) {
                    EntityLammergeier.this.setFlying(true);
                }
                super.m_8056_();
            }

            @Override
            public void m_8037_() {
                if (!EntityLammergeier.this.getFlying()) {
                    EntityLammergeier.this.setFlying(true);
                }
                super.m_8037_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new AILanding(this));
        this.f_21345_.m_25352_(5, (Goal)new AIRandomFly(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.1f){

            public boolean m_8036_() {
                return !EntityLammergeier.this.m_21824_() && !EntityLammergeier.this.getFlying() && super.m_8045_();
            }

            public boolean m_8045_() {
                return !EntityLammergeier.this.m_21824_() && !EntityLammergeier.this.getFlying() && super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean m_8036_() {
                return !EntityLammergeier.this.m_21825_() && !EntityLammergeier.this.m_21827_() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal(this){

            public boolean m_8036_() {
                return !EntityLammergeier.this.m_21825_() && !EntityLammergeier.this.m_21827_() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal<AbstractSkeleton>((Mob)this, AbstractSkeleton.class, false){

            public boolean m_8036_() {
                return !EntityLammergeier.this.m_21824_() && super.m_8036_();
            }
        });
    }

    public void m_6710_(LivingEntity entitylivingbaseIn) {
        if (!this.m_21825_() && !this.m_21827_()) {
            super.m_6710_(entitylivingbaseIn);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HEALTH_ID, (Object)Float.valueOf(this.m_21223_()));
    }

    protected SoundEvent m_7515_() {
        return this.m_21824_() && ((Float)this.f_19804_.m_135370_(DATA_HEALTH_ID)).floatValue() < 6.0f ? SoundEvents.f_12192_ : null;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12189_;
    }

    public float m_6100_() {
        return 0.4f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_21824_() && !this.m_6673_(source)) {
            this.m_21837_(false);
            this.m_21839_(false);
        }
        if (this.m_5448_() != null && this.m_5448_() == source.m_7639_() && this.m_20363_((Entity)this.m_5448_())) {
            return super.m_6469_(source, amount / 2.0f);
        }
        return super.m_6469_(source, amount);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_21824_()) {
            if (!itemstack.m_41619_() && itemstack.m_41720_().m_41472_()) {
                FoodProperties food = itemstack.m_41720_().m_41473_();
                if (((Float)this.f_19804_.m_135370_(DATA_HEALTH_ID)).floatValue() < 20.0f) {
                    if (!player.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                    for (int i = 0; i < 10; ++i) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (double)(this.m_21187_().nextFloat() - 0.5f), this.m_20186_() + (double)this.m_21187_().nextFloat(), this.m_20189_() + (double)(this.m_21187_().nextFloat() - 0.5f), 0.0, 0.0, 0.0);
                    }
                    this.m_5634_(food.m_38744_());
                    return InteractionResult.SUCCESS;
                }
            }
            if (this.m_21830_((LivingEntity)player) && !this.m_20160_() && !this.f_19853_.f_46443_ && this.f_19797_ - this.lastTick > 13 && !itemstack.m_41614_()) {
                if (!this.m_21825_() && !this.m_21827_()) {
                    this.m_6710_(null);
                    this.f_21344_.m_26573_();
                    this.readyToSit = true;
                } else {
                    this.readyToSit = false;
                    this.m_21837_(false);
                    this.m_21839_(false);
                    this.f_21344_.m_26573_();
                }
                this.lastTick = this.f_19797_;
            }
        } else if (this.isTamingItem(itemstack.m_41720_()) && !this.m_21824_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (!this.f_19853_.f_46443_) {
                if (!ModPlatformEvents.tame(this, player)) {
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_21837_(true);
                    this.m_21839_(true);
                    this.m_21153_(20.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        return this.isTamingItem(stack.m_41720_());
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            EntityLammergeier entitylam;
            if (target instanceof EntityLammergeier && (entitylam = (EntityLammergeier)target).m_21824_() && entitylam.m_142480_() == owner) {
                return false;
            }
            if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).m_30614_();
        }
        return false;
    }

    public boolean m_7327_(Entity entityIn) {
        return entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
    }

    @Override
    public void m_8119_() {
        if (Math.abs(this.m_20184_().m_7098_()) > 0.0 && (Math.abs(this.m_20184_().m_7096_()) > 0.05 || Math.abs(this.m_20184_().m_7094_()) > 0.05) || Math.abs(this.m_20184_().m_7098_()) > 0.25) {
            float x = -((float)Math.atan2(this.m_20184_().m_7098_(), Math.sqrt(Math.pow(this.m_20184_().m_7096_(), 2.0) + Math.pow(this.m_20184_().m_7094_(), 2.0))) / 1.5f);
            if (x < 0.0f) {
                x /= 3.0f;
            }
            this.rotX = x;
        } else {
            this.rotX = 0.0f;
        }
        super.m_8119_();
        this.lastMotionY = this.m_20184_().m_7098_();
        this.lastRotX = this.rotX;
    }

    protected void m_8024_() {
        super.m_8024_();
        this.f_19804_.m_135381_(DATA_HEALTH_ID, (Object)Float.valueOf(this.m_21223_()));
        this.m_20242_(this.getFlying());
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(6.0);
        }
    }

    public void m_7332_(Entity passenger) {
        passenger.m_6034_(this.m_20185_() + this.m_20184_().m_7096_(), this.m_20186_() - (double)passenger.m_20206_() - 0.05 + this.m_20184_().m_7098_(), this.m_20189_() + this.m_20184_().m_7094_());
        this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() + Math.abs(passenger.m_20184_().m_7098_()), this.m_20184_().m_7094_());
        if (passenger instanceof LivingEntity && (this.m_5448_() == null || this.m_5448_() != passenger)) {
            this.m_6710_((LivingEntity)passenger);
        }
        if (this.f_19853_.f_46443_) {
            this.m_7340_(passenger);
        }
    }

    protected boolean isValidLandingPosition(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos.m_7495_());
        return !world.m_46859_(pos.m_7495_()) && world.m_46859_(pos) && (state.m_60815_() || state.m_60796_((BlockGetter)world, pos.m_7495_()) || state.m_60734_() instanceof LeavesBlock);
    }

    protected BlockPos findLandingPosition() {
        if (this.isValidLandingPosition(this.f_19853_, this.m_142538_())) {
            return this.m_142538_();
        }
        Random random = this.m_21187_();
        for (int i = 0; i < 10; ++i) {
            float z;
            float x = (float)this.m_142538_().m_123341_() + (this.readyToSit ? (float)(random.nextInt(4) - 2) : (float)random.nextInt(16) - 8.0f) + 0.5f;
            BlockPos top = this.getTopSolidOrLiquidBlock(this.f_19853_, new BlockPos((double)x, 0.0, (double)(z = (float)this.m_142538_().m_123343_() + (this.readyToSit ? (float)(random.nextInt(4) - 2) : (float)random.nextInt(16) - 8.0f) + 0.5f)));
            if (top == null) continue;
            float y = top.m_123342_();
            return new BlockPos((double)x, (double)y, (double)z);
        }
        return null;
    }

    protected BlockPos getTopSolidOrLiquidBlock(Level world, BlockPos pos) {
        for (int i = world.m_151558_(); i > world.m_5736_(); --i) {
            BlockPos pos2 = new BlockPos(pos.m_123341_(), i, pos.m_123343_());
            if (!this.isValidLandingPosition(world, pos2)) continue;
            return pos2;
        }
        return null;
    }

    @Override
    public EntityTypeContainerBAPTameable<EntityLammergeier> getContainer() {
        return ModEntities.LAMMERGEIER;
    }

    @Override
    protected EntityTameableWithTypes getBaseChild() {
        return null;
    }

    @Override
    protected MoveControl getFlightMoveController() {
        return this.flightControl;
    }

    static class AIMeleeAttack
    extends Goal {
        protected Level world;
        protected EntityLammergeier attacker;
        protected int attackTick;
        protected double liftY = 0.0;

        public AIMeleeAttack(EntityLammergeier lam) {
            this.attacker = lam;
            this.world = lam.m_20193_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity entitylivingbase = this.attacker.m_5448_();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.m_6084_()) {
                return false;
            }
            return !(entitylivingbase instanceof Player) || !entitylivingbase.m_20147_();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            LivingEntity entitylivingbase = this.attacker.m_5448_();
            if (entitylivingbase instanceof Player && (entitylivingbase.m_5833_() || ((Player)entitylivingbase).m_7500_())) {
                this.attacker.m_6710_(null);
            }
        }

        public void m_8037_() {
            Mob el;
            if (!this.attacker.getFlying()) {
                this.attacker.setFlying(true);
            }
            LivingEntity entitylivingbase = this.attacker.m_5448_();
            double targetX = entitylivingbase.m_20185_();
            double targetZ = entitylivingbase.m_20189_();
            if (entitylivingbase.m_20280_((Entity)this.attacker) < 4096.0) {
                double d1 = entitylivingbase.m_20185_() - this.attacker.m_20185_();
                double d2 = entitylivingbase.m_20189_() - this.attacker.m_20189_();
                this.attacker.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                this.attacker.f_20883_ = this.attacker.m_146908_();
            }
            double distanceToTarget = this.attacker.m_20275_(entitylivingbase.m_20185_(), entitylivingbase.m_20186_(), entitylivingbase.m_20189_());
            --this.attackTick;
            double reachToTarget = this.getAttackReachSqr(entitylivingbase);
            if (distanceToTarget <= reachToTarget && this.attackTick <= 0) {
                this.attackTick = 20;
                if (!entitylivingbase.m_20363_((Entity)this.attacker)) {
                    this.attacker.m_7327_((Entity)entitylivingbase);
                }
            }
            if (this.attacker.m_20197_().size() == 0) {
                this.attacker.f_21344_.m_26536_(this.attacker.f_21344_.m_7864_(entitylivingbase.m_142538_(), 0), 0.4);
            } else {
                this.attacker.f_21344_.m_26536_(this.attacker.f_21344_.m_7864_(new BlockPos(targetX, this.liftY + 15.0, targetZ), 0), 0.4);
            }
            if (distanceToTarget <= reachToTarget && this.attacker.m_20197_().size() == 0 && entitylivingbase.m_20206_() <= 3.0f && this.attackTick == 15) {
                this.attacker.m_7678_(this.attacker.m_20185_(), this.attacker.m_20186_() + (double)entitylivingbase.m_20206_() + 2.0, this.attacker.m_20189_(), this.attacker.m_146908_(), this.attacker.m_146909_());
                entitylivingbase.m_7998_((Entity)this.attacker, true);
                this.liftY = entitylivingbase.m_20186_();
                if (entitylivingbase instanceof Mob) {
                    el = (Mob)entitylivingbase;
                    el.m_6710_(null);
                    el.m_6703_(null);
                    el.m_21573_().m_26573_();
                    el.m_21557_(true);
                }
                this.attacker.f_21344_.m_26536_(this.attacker.f_21344_.m_7864_(new BlockPos(targetX, this.liftY + 15.0, targetZ), 0), 0.4);
            }
            if (this.attacker.m_20197_().size() == 0 && this.attacker.m_20193_().m_8055_(this.attacker.m_142538_().m_7494_()).m_60796_((BlockGetter)this.world, this.attacker.m_142538_().m_7494_())) {
                entitylivingbase.m_8127_();
                if (entitylivingbase instanceof Mob) {
                    el = (Mob)entitylivingbase;
                    el.m_21557_(false);
                }
                this.attacker.m_6710_(null);
                BlockPos rPos = new BlockPos(this.attacker.m_21187_().nextInt(50) - 25, this.attacker.m_21187_().nextInt(40) - 20, this.attacker.m_21187_().nextInt(50) - 25);
                BlockPos pos = this.attacker.m_142538_();
                rPos = rPos.m_141952_((Vec3i)pos);
                this.attacker.f_21344_.m_26536_(this.attacker.f_21344_.m_7864_(rPos, 0), 0.4);
            }
            if (Math.abs(this.attacker.m_20186_() - (this.liftY + 15.0)) <= 3.0 && this.attacker.m_20197_().size() > 0) {
                entitylivingbase.m_8127_();
                if (entitylivingbase instanceof Mob) {
                    el = (Mob)entitylivingbase;
                    el.m_21557_(false);
                }
            }
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return 4.0 + (double)attackTarget.m_20205_();
        }
    }

    public static class AILanding
    extends Goal {
        private final EntityLammergeier parentEntity;
        private BlockPos target;
        private int timeSinceLastMove = 0;
        private double lastDist = 0.0;

        public AILanding(EntityLammergeier lam) {
            this.parentEntity = lam;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.parentEntity.m_5448_() != null && this.parentEntity.m_5448_().m_6084_()) {
                return false;
            }
            if (!this.parentEntity.m_21824_() && this.parentEntity.getFlying() && this.parentEntity.m_21187_().nextInt(200) == 1) {
                return true;
            }
            return this.parentEntity.m_21824_() && this.parentEntity.readyToSit;
        }

        public boolean m_8045_() {
            return this.target != null && this.parentEntity.m_142538_().m_123331_((Vec3i)this.target) > 1.0;
        }

        public void m_8056_() {
            BlockPos rPos = this.parentEntity.findLandingPosition();
            if (rPos != null) {
                this.target = rPos;
                this.parentEntity.f_21344_.m_26519_((double)rPos.m_123341_(), (double)rPos.m_123342_(), (double)rPos.m_123343_(), 1.1);
            } else if (this.parentEntity.readyToSit) {
                this.parentEntity.m_21837_(true);
                this.parentEntity.m_21839_(true);
                this.parentEntity.readyToSit = false;
            }
            this.timeSinceLastMove = 0;
        }

        public void m_8037_() {
            if (this.target != null) {
                this.parentEntity.f_21344_.m_26519_((double)this.target.m_123341_(), (double)this.target.m_123342_(), (double)this.target.m_123343_(), 1.1);
                double dist = this.parentEntity.m_142538_().m_123331_((Vec3i)this.target);
                Level world = this.parentEntity.f_19853_;
                BlockPos top = this.parentEntity.getTopSolidOrLiquidBlock(world, this.parentEntity.m_142538_());
                if (dist < 3.0 && top != null && Math.abs(this.parentEntity.m_142538_().m_123342_() - top.m_123342_()) <= 3) {
                    this.parentEntity.setFlying(false);
                    this.target = null;
                    if (this.parentEntity.readyToSit) {
                        this.parentEntity.m_21837_(true);
                        this.parentEntity.m_21839_(true);
                        this.parentEntity.readyToSit = false;
                        this.parentEntity.m_21573_().m_26573_();
                        this.parentEntity.m_20334_(0.0, 0.0, 0.0);
                    }
                } else if (dist - this.lastDist < 0.05) {
                    BlockPos rPos;
                    ++this.timeSinceLastMove;
                    if (this.timeSinceLastMove > 60 && (rPos = this.parentEntity.findLandingPosition()) != null) {
                        this.target = rPos;
                        this.parentEntity.f_21344_.m_26519_((double)rPos.m_123341_(), (double)rPos.m_123342_(), (double)rPos.m_123343_(), 1.1);
                    }
                } else {
                    this.timeSinceLastMove = 0;
                }
                this.lastDist = dist;
            }
        }
    }

    static class AIRandomFly
    extends Goal {
        private final EntityLammergeier parentEntity;
        private int timeSinceLastMove = 0;
        private double lastDist = 0.0;

        public AIRandomFly(EntityLammergeier lam) {
            this.parentEntity = lam;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            boolean exec;
            double d2;
            double d1;
            if (this.parentEntity.m_21824_() || this.parentEntity.m_5448_() != null && this.parentEntity.m_5448_().m_6084_()) {
                return false;
            }
            if (!this.parentEntity.getFlying() && this.parentEntity.m_21187_().nextInt(100) != 1) {
                return false;
            }
            MoveControl move = this.parentEntity.m_21566_();
            double d0 = move.m_25000_() - this.parentEntity.m_20185_();
            double distance = d0 * d0 + (d1 = move.m_25001_() - this.parentEntity.m_20186_()) * d1 + (d2 = move.m_25002_() - this.parentEntity.m_20189_()) * d2;
            boolean bl = exec = distance < 1.0 || distance > 3600.0;
            if (!exec) {
                ++this.timeSinceLastMove;
            }
            if (this.timeSinceLastMove > 60) {
                this.timeSinceLastMove = 0;
                return true;
            }
            return exec;
        }

        public boolean m_8045_() {
            return !this.parentEntity.m_21573_().m_26571_();
        }

        public void m_8037_() {
            if (!this.parentEntity.getFlying()) {
                this.parentEntity.setFlying(true);
            }
            boolean idle = true;
            if (this.parentEntity.f_21344_.m_26570_() != null && this.parentEntity.f_21344_.m_26570_().m_77399_() < this.parentEntity.f_21344_.m_26570_().m_77398_()) {
                double dist = this.parentEntity.m_142538_().m_123331_((Vec3i)this.parentEntity.f_21344_.m_26570_().m_77400_());
                idle = dist - this.lastDist < 0.05;
                this.lastDist = dist;
            }
            if (idle) {
                ++this.timeSinceLastMove;
                if (this.timeSinceLastMove > 60) {
                    this.parentEntity.f_21344_.m_26573_();
                    this.parentEntity.f_21344_.m_26569_();
                    this.parentEntity.m_21566_().m_6849_(this.parentEntity.m_20185_() + (double)this.parentEntity.m_21187_().nextInt(3) - 1.0, this.parentEntity.m_20186_() + (double)this.parentEntity.m_21187_().nextInt(3) - 1.0, this.parentEntity.m_20189_() + (double)this.parentEntity.m_21187_().nextInt(3) - 1.0, 0.5);
                }
            } else {
                this.timeSinceLastMove = 0;
            }
        }

        public void m_8056_() {
            if (!this.parentEntity.getFlying()) {
                this.parentEntity.setFlying(true);
            }
            BlockPos rPos = new BlockPos(this.parentEntity.m_21187_().nextInt(50) - 25, this.parentEntity.m_21187_().nextInt(40) - 20, this.parentEntity.m_21187_().nextInt(50) - 25);
            BlockPos pos = this.parentEntity.m_142538_();
            rPos = rPos.m_141952_((Vec3i)pos);
            this.parentEntity.f_21344_.m_26519_((double)rPos.m_123341_(), (double)rPos.m_123342_(), (double)rPos.m_123343_(), 1.0);
        }
    }
}

