/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.EntityBobbitWorm;
import dev.itsmeow.betteranimalsplus.common.entity.ai.EfficientMoveTowardsTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.ai.HungerNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.ai.PeacefulNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntitySharkBase;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathing;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.util.OceanBiomeHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class EntityShark
extends EntitySharkBase {
    private float lastAttack = 0.0f;
    private float lastGrab = 0.0f;
    private float lastTickHealth = 0.0f;
    public float lastBodyRotation = 0.0f;

    public EntityShark(EntityType<? extends EntityShark> entityType, Level worldIn) {
        super((EntityType<? extends EntitySharkBase>)entityType, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new EfficientMoveTowardsTargetGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 15.0f));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1));
        this.f_21346_.m_25352_(1, new HungerNearestAttackableTargetGoal<LivingEntity, EntityShark>(this, LivingEntity.class, 5, false, false, e -> !(e instanceof EntitySharkBase) && !(e instanceof EntityBobbitWorm) && !(e instanceof Player)));
        this.f_21346_.m_25352_(2, new PeacefulNearestAttackableTargetGoal<Player>((Mob)this, Player.class, 5, false, false, e -> this.shouldAttackForHealth(e.m_21223_())));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            Player player;
            if (source.m_7640_() instanceof Player && !this.isPeaceful() && !(player = (Player)source.m_7640_()).m_7500_() && !player.m_20145_()) {
                this.m_6710_((LivingEntity)player);
            }
            return true;
        }
        return false;
    }

    @Override
    public IVariantTypes<EntityWaterMobPathing> setType(IVariant variant) {
        super.setType(variant);
        this.updateAttributes(this.getVariantNameOrEmpty());
        return this;
    }

    @Override
    public IVariantTypes<EntityWaterMobPathing> setType(String variantKey) {
        super.setType(variantKey);
        this.updateAttributes(this.getVariantNameOrEmpty());
        return this;
    }

    private void updateAttributes(String name) {
        if ("hammerhead".equals(name)) {
            this.m_21051_(Attributes.f_22276_).m_22100_(45.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(9.0);
        } else if ("mako".equals(name)) {
            this.m_21051_(Attributes.f_22279_).m_22100_(3.0);
        } else if ("great_white".equals(name)) {
            this.m_21051_(Attributes.f_22276_).m_22100_(60.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(12.0);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(6.0);
            this.m_21051_(Attributes.f_22279_).m_22100_(1.5);
        }
        this.m_21153_(this.m_21233_());
    }

    public boolean shouldAttackForHealth(float health) {
        switch (this.getVariantNameOrEmpty()) {
            case "blue": {
                return health <= 8.0f;
            }
            case "bull": {
                return health <= 13.0f;
            }
            case "tiger": {
                return health <= 10.0f;
            }
            case "whitetip": {
                return health <= 16.0f;
            }
            case "greenland": {
                return health <= 8.0f;
            }
            case "hammerhead": {
                return health <= 8.0f;
            }
            case "goblin": {
                return health <= 8.0f;
            }
            case "mako": {
                return health <= 13.0f;
            }
            case "great_white": {
                return health <= 13.0f;
            }
        }
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
        if (!this.f_19853_.f_46443_ && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_6084_() && !this.isPeaceful()) {
            float grabDelay;
            boolean isBoat = this.m_5448_() instanceof Player && this.m_5448_().m_20202_() != null && this.m_5448_().m_20202_() instanceof Boat;
            float f = grabDelay = isBoat ? 20.0f : 60.0f;
            if (this.m_20197_().contains(this.m_5448_())) {
                float time = 30.0f * ((float)Math.random() + 1.0f);
                if (this.lastAttack + time < (float)this.f_19797_) {
                    this.m_7327_((Entity)this.m_5448_());
                }
            } else if (this.lastGrab + grabDelay < (float)this.f_19797_ && this.m_20280_((Entity)this.m_5448_()) < 5.0) {
                if (isBoat) {
                    Boat boat = (Boat)this.m_5448_().m_20202_();
                    boat.m_6469_(DamageSource.m_19370_((LivingEntity)this), 3.0f);
                } else if (!this.m_5448_().m_20147_() && (double)this.m_5448_().m_20205_() < 2.5 && (double)this.m_5448_().m_20206_() < 2.5) {
                    if (this.m_5448_() instanceof Mob) {
                        Mob el = (Mob)this.m_5448_();
                        el.m_6710_(null);
                        el.m_6703_(null);
                        el.m_21573_().m_26573_();
                        el.m_21557_(true);
                    }
                    this.m_5448_().m_7998_((Entity)this, false);
                } else if (!this.m_5448_().m_20147_()) {
                    this.m_7327_((Entity)this.m_5448_());
                }
                this.lastGrab = this.f_19797_;
            }
            if (this.lastTickHealth - 4.0f > this.m_21223_()) {
                this.m_5448_().m_8127_();
                if (this.m_5448_() instanceof Mob) {
                    Mob el = (Mob)this.m_5448_();
                    el.m_21557_(false);
                }
            }
        }
        this.lastTickHealth = this.m_21223_();
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            this.lastAttack = this.f_19797_;
            return true;
        }
        return false;
    }

    @Override
    public EntityTypeContainer<EntityShark> getContainer() {
        return ModEntities.SHARK;
    }

    @Override
    public String[] getTypesFor(ResourceKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, MobSpawnType reason) {
        ArrayList<String> list = new ArrayList<String>();
        OceanBiomeHelper.Wrapper b = new OceanBiomeHelper.Wrapper(biomeKey);
        if (b.isColdOrFrozen()) {
            list.add("greenland");
        } else {
            list.add("bull");
            list.add("blue");
            list.add("whitetip");
            list.add("tiger");
        }
        if (!b.isFrozen()) {
            list.add("great_white");
        }
        if (b.isDeep()) {
            list.add("goblin");
            if (!b.isFrozen()) {
                list.add("mako");
            }
        }
        if (b.isWarm()) {
            list.add("mako");
            list.add("hammerhead");
        }
        return list.toArray(new String[0]);
    }

    @Override
    public IVariant getRandomVariantForBiome(LevelAccessor world, MobSpawnType reason) {
        Optional<IVariant> variant;
        int i;
        Holder biome = world.m_204166_(this.getImplementation().m_142538_());
        Optional biomeKey = biome.m_203543_();
        biomeKey.orElseThrow(() -> new RuntimeException("Biome provided to selective type generation has no ID found."));
        String[] validTypes = this.getTypesFor((ResourceKey<Biome>)((ResourceKey)biomeKey.get()), (Biome)biome.m_203334_(), BiomeTypes.getTypes((ResourceKey<Biome>)((ResourceKey)biomeKey.get())), reason);
        String varStr = validTypes[this.getImplementation().m_21187_().nextInt(validTypes.length)];
        for (i = 0; i < 2; ++i) {
            if (!"great_white".equals(varStr) && !"goblin".equals(varStr)) continue;
            varStr = validTypes[this.getImplementation().m_21187_().nextInt(validTypes.length)];
        }
        if (world instanceof Level && ((Level)world).m_46461_() && validTypes.length > 1 && "goblin".equals(varStr)) {
            for (i = 0; i < validTypes.length && "goblin".equals(varStr); ++i) {
                varStr = validTypes[i];
            }
        }
        if (!(variant = this.getContainer().getVariantForName(varStr)).isPresent() || !varStr.equals(variant.get().getName())) {
            throw new RuntimeException("Received invalid variant \"" + varStr + "\" from selective type on entity " + this.getContainer().getEntityName());
        }
        return variant.get();
    }
}

