/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity;

import com.google.common.collect.Sets;
import dev.itsmeow.betteranimalsplus.imdlib.IMDLib;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.imdlib.util.BiomeListBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.util.HeadType;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;

public abstract class AbstractEntityBuilder<T extends Mob, C extends EntityTypeContainer<T>, B extends AbstractEntityBuilder<T, C, B>>
implements IEntityBuilder<T, C, B> {
    protected final Class<T> entityClass;
    protected final String entityName;
    protected final EntityType.EntityFactory<T> factory;
    protected final String modid;
    protected final Supplier<AttributeSupplier.Builder> attributeMap;
    public boolean hasSpawns;
    protected MobCategory spawnType;
    protected int eggColorSolid;
    protected int eggColorSpot;
    protected int spawnWeight;
    protected boolean useSpawnCosts;
    protected int spawnMinGroup;
    protected int spawnMaxGroup;
    protected double spawnCostPer;
    protected double spawnMaxCost;
    protected float width;
    protected float height;
    protected boolean despawn;
    protected EntityTypeContainer.CustomConfigurationLoad customConfigLoad;
    protected EntityTypeContainer.CustomConfigurationInit customConfigInit;
    protected EntityTypeContainer.CustomConfigurationLoad customClientConfigLoad;
    protected EntityTypeContainer.CustomConfigurationInit customClientConfigInit;
    protected Supplier<Set<ResourceKey<Biome>>> defaultBiomeSupplier;
    protected SpawnPlacements.Type placementType;
    protected Heightmap.Types heightMapType;
    protected SpawnPlacements.SpawnPredicate<T> placementPredicate;
    protected int variantCount = 0;
    protected IVariant[] variants;
    protected boolean hasEgg;
    protected Function<C, HeadType> headTypeBuilder;

    protected AbstractEntityBuilder(Class<T> EntityClass, EntityType.EntityFactory<T> factory, String entityNameIn, Supplier<AttributeSupplier.Builder> attributeMap, String modid) {
        this.entityClass = EntityClass;
        this.factory = factory;
        this.entityName = entityNameIn;
        this.modid = modid;
        this.eggColorSolid = 0;
        this.eggColorSpot = 0xFFFFFF;
        this.spawnWeight = 1;
        this.spawnMinGroup = 1;
        this.spawnMaxGroup = 1;
        this.useSpawnCosts = false;
        this.spawnCostPer = 1.0;
        this.spawnMaxCost = 10.0;
        this.spawnType = MobCategory.CREATURE;
        this.hasSpawns = false;
        this.width = 1.0f;
        this.height = 1.0f;
        this.despawn = false;
        this.hasEgg = false;
        this.defaultBiomeSupplier = HashSet::new;
        this.placementType = null;
        this.heightMapType = null;
        this.placementPredicate = null;
        this.attributeMap = attributeMap;
    }

    protected static Supplier<Set<ResourceKey<Biome>>> toBiomes(BiomeTypes.Type[] biomeTypes, boolean overworldOnly) {
        return () -> {
            HashSet<ResourceKey> set = new HashSet<ResourceKey>();
            Registry reg = null;
            try {
                reg = IMDLib.getStaticServerInstance().m_206579_().m_175515_(Registry.f_122885_);
            }
            catch (RuntimeException e) {
                return set;
            }
            for (Biome biome : reg) {
                ResourceKey biomeResourceKey = (ResourceKey)reg.m_7854_((Object)biome).orElseThrow(RuntimeException::new);
                for (BiomeTypes.Type predicate : biomeTypes) {
                    if (!predicate.hasType((ResourceKey<Biome>)biomeResourceKey) || overworldOnly && !BiomeTypes.OVERWORLD.hasType((ResourceKey<Biome>)biomeResourceKey)) continue;
                    set.add(biomeResourceKey);
                }
            }
            return set;
        };
    }

    public abstract B getImplementation();

    @Override
    public B spawn(MobCategory type, int weight, int min, int max) {
        this.hasSpawns = true;
        this.spawnType = type;
        this.spawnWeight = weight;
        this.spawnMinGroup = min;
        this.spawnMaxGroup = max;
        return this.getImplementation();
    }

    @Override
    public B spawnCosts(double cost, double maxCost) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before spawn costs");
        }
        this.useSpawnCosts = true;
        this.spawnCostPer = cost;
        this.spawnMaxCost = maxCost;
        return this.getImplementation();
    }

    @Override
    public B egg(int solid, int spot) {
        this.hasEgg = true;
        this.eggColorSolid = solid;
        this.eggColorSpot = spot;
        return this.getImplementation();
    }

    @Override
    public B size(float width, float height) {
        this.width = width;
        this.height = height;
        return this.getImplementation();
    }

    @Override
    public B despawn() {
        this.despawn = true;
        return this.getImplementation();
    }

    @Override
    public B config(EntityTypeContainer.CustomConfigurationInit configurationInit) {
        return (B)this.config(configurationInit, holder -> {});
    }

    @Override
    public B clientConfig(EntityTypeContainer.CustomConfigurationInit configurationInit) {
        return (B)this.clientConfig(configurationInit, holder -> {});
    }

    @Override
    public B config(EntityTypeContainer.CustomConfigurationInit configurationInit, EntityTypeContainer.CustomConfigurationLoad configurationLoad) {
        this.customConfigLoad = configurationLoad;
        this.customConfigInit = configurationInit;
        return this.getImplementation();
    }

    @Override
    public B clientConfig(EntityTypeContainer.CustomConfigurationInit configurationInit, EntityTypeContainer.CustomConfigurationLoad configurationLoad) {
        this.customClientConfigLoad = configurationLoad;
        this.customClientConfigInit = configurationInit;
        return this.getImplementation();
    }

    @Override
    public B placement(SpawnPlacements.Type type, Heightmap.Types heightMap, SpawnPlacements.SpawnPredicate<T> predicate) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before placement");
        }
        this.placementType = type;
        this.heightMapType = heightMap;
        this.placementPredicate = predicate;
        return this.getImplementation();
    }

    @Override
    public B defaultPlacement(SpawnPlacements.SpawnPredicate<T> predicate) {
        return (B)this.placement(SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate)predicate);
    }

    @Override
    public B waterPlacement() {
        return (B)this.placement(SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityTypeContainer::waterSpawn);
    }

    @Override
    public B waterPlacement(SpawnPlacements.SpawnPredicate<T> predicate) {
        return (B)this.placement(SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate)predicate);
    }

    @Override
    public B biomes(BiomeTypes.Type ... biomeTypes) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before biomes");
        }
        this.defaultBiomeSupplier = AbstractEntityBuilder.toBiomes(biomeTypes, false);
        return this.getImplementation();
    }

    @Override
    public B biomesOverworld(BiomeTypes.Type ... biomeTypes) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before biomes");
        }
        this.defaultBiomeSupplier = AbstractEntityBuilder.toBiomes(biomeTypes, true);
        return this.getImplementation();
    }

    @Override
    public B biomes(Supplier<ResourceKey<Biome>[]> biomes) {
        if (!this.hasSpawns) {
            throw new RuntimeException("You must specify spawns before biomes");
        }
        this.defaultBiomeSupplier = () -> Sets.newHashSet((Object[])((ResourceKey[])biomes.get()));
        return this.getImplementation();
    }

    @Override
    public B biomes(Function<BiomeListBuilder, BiomeListBuilder> biomes) {
        return (B)this.biomes(biomes.apply(BiomeListBuilder.create())::collect);
    }

    @Override
    public B variants(IVariant ... variants) {
        this.variantCount = variants.length;
        this.variants = variants;
        return this.getImplementation();
    }

    @Override
    public B variants(String ... nameTextures) {
        this.variantCount = nameTextures.length;
        this.variants = new EntityVariant[nameTextures.length];
        for (int i = 0; i < nameTextures.length; ++i) {
            String nameTex = nameTextures[i];
            this.variants[i] = new EntityVariant(this.modid, nameTex, this.entityName + "_" + nameTex);
        }
        return this.getImplementation();
    }

    @Override
    public B variants(int max) {
        if (max > 0) {
            this.variantCount = max;
            this.variants = new EntityVariant[max];
            for (int i = 0; i < max; ++i) {
                String nameTex = String.valueOf(i + 1);
                this.variants[i] = new EntityVariant(this.modid, nameTex, this.entityName + "_" + nameTex);
            }
        } else {
            throw new RuntimeException("what are you doing kid");
        }
        return this.getImplementation();
    }

    @Override
    public B variants(Function<String, IVariant> constructor, String ... variants) {
        this.variantCount = variants.length;
        IVariant[] variantList = new IVariant[this.variantCount];
        for (int i = 0; i < this.variantCount; ++i) {
            variantList[i] = constructor.apply(variants[i]);
        }
        this.variants = variantList;
        return this.getImplementation();
    }

    @Override
    public HeadType.Builder<T, C, B> head(String headName) {
        return new HeadType.Builder(this.getImplementation(), headName);
    }

    @Override
    public HeadType.Builder<T, C, B> head() {
        return this.head(this.entityName + "head");
    }

    @Override
    public void postBuild(C container) {
        if (this.headTypeBuilder != null) {
            ((EntityTypeContainer)container).setHeadType(this.headTypeBuilder.apply(container));
        }
    }

    @Override
    public void setHeadBuild(Function<C, HeadType> builder) {
        this.headTypeBuilder = builder;
    }

    @Override
    public String getMod() {
        return this.modid;
    }
}

