/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntityRenderer;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntityRenderer;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.gui.ElevatorScreen;
import com.supermartijn642.movingelevators.model.CamoBakedModel;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class MovingElevatorsClient {
    public static final ResourceLocation OVERLAY_TEXTURE_LOCATION = new ResourceLocation("movingelevators", "blocks/block_overlays");
    public static TextureAtlasSprite OVERLAY_SPRITE;

    @SubscribeEvent
    public static void setup(EntityRenderersEvent.RegisterRenderers e) {
        e.registerBlockEntityRenderer(MovingElevators.elevator_tile, context -> new ElevatorInputBlockEntityRenderer());
        e.registerBlockEntityRenderer(MovingElevators.display_tile, context -> new DisplayBlockEntityRenderer());
        e.registerBlockEntityRenderer(MovingElevators.button_tile, context -> new ElevatorInputBlockEntityRenderer());
    }

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        ItemBlockRenderTypes.setRenderLayer((Block)MovingElevators.elevator_block, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)MovingElevators.display_block, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)MovingElevators.button_block, (RenderType)RenderType.m_110466_());
        ClientUtils.getMinecraft().m_91298_().m_92589_((state, blockAndTintGetter, pos, p_92570_) -> {
            if (blockAndTintGetter == null || pos == null) {
                return 0;
            }
            BlockEntity entity = blockAndTintGetter.m_7702_(pos);
            return entity instanceof CamoBlockEntity && ((CamoBlockEntity)entity).hasCamoState() ? ClientUtils.getMinecraft().m_91298_().m_92577_(((CamoBlockEntity)entity).getCamoState(), blockAndTintGetter, pos, p_92570_) : 0;
        }, new Block[]{MovingElevators.elevator_block, MovingElevators.display_block, MovingElevators.button_block});
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent e) {
        MovingElevatorsClient.setCamouflageModel(e, (Block)MovingElevators.elevator_block);
        MovingElevatorsClient.setCamouflageModel(e, (Block)MovingElevators.display_block);
        MovingElevatorsClient.setCamouflageModel(e, (Block)MovingElevators.button_block);
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre e) {
        if (e.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            e.addSprite(OVERLAY_TEXTURE_LOCATION);
        }
    }

    @SubscribeEvent
    public static void onTextureStitchPost(TextureStitchEvent.Post e) {
        if (e.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            OVERLAY_SPRITE = e.getAtlas().m_118316_(OVERLAY_TEXTURE_LOCATION);
        }
    }

    private static void setCamouflageModel(ModelBakeEvent e, Block block) {
        for (BlockState state : block.m_49965_().m_61056_()) {
            StringBuilder builder = new StringBuilder();
            if (!state.m_61148_().isEmpty()) {
                builder.append(state.m_61148_().entrySet().stream().map(entry -> MovingElevatorsClient.getPropertyName((Property)entry.getKey(), (Comparable)entry.getValue())).collect(Collectors.joining(",")));
            }
            ModelResourceLocation modelLocation = new ModelResourceLocation(block.getRegistryName(), builder.toString());
            BakedModel model = e.getModelManager().m_119422_(modelLocation);
            e.getModelRegistry().put(modelLocation, new CamoBakedModel(model));
        }
    }

    private static <T extends Comparable<T>> String getPropertyName(Property<T> property, Comparable<?> value) {
        return property.m_61708_() + "=" + property.m_6940_(value);
    }

    public static void openElevatorScreen(BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new ElevatorScreen(pos));
    }

    public static String formatFloorDisplayName(String name, int floor) {
        return name == null ? TextComponents.translation((String)"movingelevators.floor_name", (Object[])new Object[]{TextComponents.number((int)floor).get()}).format() : name;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventListeners {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent e) {
            if (e.phase == TickEvent.Phase.END && !Minecraft.m_91087_().m_91104_() && Minecraft.m_91087_().f_91073_ != null) {
                ElevatorGroupCapability.tickWorldCapability((Level)Minecraft.m_91087_().f_91073_);
            }
        }
    }
}

