/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CamoBlock
extends BaseBlock
implements EntityBlock {
    private final BiFunction<BlockPos, BlockState, ? extends CamoBlockEntity> tileSupplier;

    public CamoBlock(String registryName, BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, ? extends CamoBlockEntity> tileSupplier) {
        super(registryName, false, properties.m_60988_());
        this.tileSupplier = tileSupplier;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult rayTraceResult) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof CamoBlockEntity) {
            this.onRightClick(state, worldIn, (CamoBlockEntity)blockEntity, pos, player, handIn, rayTraceResult);
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    protected boolean onRightClick(BlockState state, Level worldIn, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult rayTraceResult) {
        if (player.m_6144_() && player.m_21120_(handIn).m_41619_()) {
            blockEntity.setCamoState(null);
            return true;
        }
        if (!player.m_6144_() && blockEntity.canBeCamoStack(player.m_21120_(handIn))) {
            Item item = player.m_21120_(handIn).m_41720_();
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).m_40614_();
                BlockState state1 = block.m_5573_(new BlockPlaceContext(new UseOnContext(player, handIn, rayTraceResult)));
                if (state1 == null) {
                    state1 = block.m_49966_();
                }
                blockEntity.setCamoState(state1);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (BlockEntity)this.tileSupplier.apply(pos, state);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = reader.m_7702_(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().m_60771_(reader, pos, context) : BlockShape.fullCube().getUnderlying();
    }

    public int getLightEmission(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockEntity blockEntity = reader.m_7702_(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().getLightEmission(reader, pos) : super.getLightEmission(state, reader, pos);
    }

    public float m_7749_(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockEntity blockEntity = reader.m_7702_(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().m_60792_(reader, pos) : super.m_7749_(state, reader, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockEntity blockEntity = reader.m_7702_(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().m_60631_(reader, pos) : super.m_7420_(state, reader, pos);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return BlockShape.empty().getUnderlying();
    }

    public int m_7753_(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockEntity blockEntity = reader instanceof Level ? ((Level)reader).m_7726_().m_6196_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_())).m_7702_(pos) : reader.m_7702_(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().m_60739_(reader, pos) : reader.m_7469_();
    }
}

