/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;

public class ElevatorInputBlockEntityRenderer<T extends ElevatorInputBlockEntity>
implements BlockEntityRenderer<T> {
    public void render(T entity, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        if (!((ElevatorInputBlockEntity)((Object)entity)).hasGroup() || ((ElevatorInputBlockEntity)((Object)entity)).getFacing() == null || entity instanceof ControllerBlockEntity && !((ControllerBlockEntity)((Object)entity)).shouldShowButtons()) {
            return;
        }
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
        Direction facing = ((ElevatorInputBlockEntity)((Object)entity)).getFacing();
        combinedLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_58904_(), (BlockPos)entity.m_58899_().m_142300_(facing));
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(new Quaternion(0.0f, 180.0f - facing.m_122435_(), 0.0f, true));
        matrixStack.m_85837_(-0.5, -0.5, -0.51);
        ElevatorGroup group = ((ElevatorInputBlockEntity)((Object)entity)).getGroup();
        int floorNumber = group.getFloorNumber(((ElevatorInputBlockEntity)((Object)entity)).getFloorLevel());
        int floorCount = group.getFloorCount();
        this.drawOverlayPart(matrixStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, floorNumber < floorCount - 1 ? 64 : 87, 23, 23);
        this.drawOverlayPart(matrixStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 23, 64, 23, 23);
        this.drawOverlayPart(matrixStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 46, floorNumber > 0 ? 64 : 87, 23, 23);
        matrixStack.m_85849_();
    }

    private void drawOverlayPart(PoseStack matrixStack, VertexConsumer buffer, int combinedLight, int combinedOverlay, Direction facing, float x, float y, float width, float height, int tX, int tY, int tWidth, int tHeight) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        Matrix3f normalMatrix = matrixStack.m_85850_().m_85864_();
        float minU = MovingElevatorsClient.OVERLAY_SPRITE.m_118367_((double)((float)tX / 8.0f));
        float maxU = MovingElevatorsClient.OVERLAY_SPRITE.m_118367_((double)((float)(tX + tWidth) / 8.0f));
        float minV = MovingElevatorsClient.OVERLAY_SPRITE.m_118393_((double)((float)tY / 8.0f));
        float maxV = MovingElevatorsClient.OVERLAY_SPRITE.m_118393_((double)((float)(tY + tHeight) / 8.0f));
        buffer.m_85982_(matrix, x, y + height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(maxU, minV).m_85969_(combinedLight).m_85977_(normalMatrix, (float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_()).m_86008_(combinedOverlay).m_5752_();
        buffer.m_85982_(matrix, x + width, y + height, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(minU, minV).m_85969_(combinedLight).m_85977_(normalMatrix, (float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_()).m_86008_(combinedOverlay).m_5752_();
        buffer.m_85982_(matrix, x + width, y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_85969_(combinedLight).m_85977_(normalMatrix, (float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_()).m_86008_(combinedOverlay).m_5752_();
        buffer.m_85982_(matrix, x, y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_85969_(combinedLight).m_85977_(normalMatrix, (float)facing.m_122429_(), (float)facing.m_122430_(), (float)facing.m_122431_()).m_86008_(combinedOverlay).m_5752_();
    }
}

