/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlock;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockEntity;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class RemoteControllerBlock
extends ElevatorInputBlock {
    public RemoteControllerBlock(String registryName, BlockBehaviour.Properties properties) {
        super(registryName, properties, (BiFunction<BlockPos, BlockState, ? extends ElevatorInputBlockEntity>)((BiFunction<BlockPos, BlockState, ElevatorInputBlockEntity>)RemoteControllerBlockEntity::new));
    }

    @Override
    protected boolean onRightClick(BlockState state, Level worldIn, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult rayTraceResult) {
        if (super.onRightClick(state, worldIn, blockEntity, pos, player, handIn, rayTraceResult)) {
            return true;
        }
        if (blockEntity instanceof RemoteControllerBlockEntity) {
            if (worldIn.f_46443_) {
                BlockPos controllerPos = ((RemoteControllerBlockEntity)blockEntity).getControllerPos();
                MutableComponent x = TextComponents.number((int)controllerPos.m_123341_()).color(ChatFormatting.GOLD).get();
                MutableComponent y = TextComponents.number((int)controllerPos.m_123342_()).color(ChatFormatting.GOLD).get();
                MutableComponent z = TextComponents.number((int)controllerPos.m_123343_()).color(ChatFormatting.GOLD).get();
                player.m_5661_((Component)TextComponents.translation((String)"movingelevators.remote_controller.controller_location", (Object[])new Object[]{x, y, z}).get(), true);
            }
            return true;
        }
        return false;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof RemoteControllerBlockEntity) {
            CompoundTag compound = stack.m_41783_();
            if (compound == null || !compound.m_128441_("controllerDim")) {
                return;
            }
            ((RemoteControllerBlockEntity)tile).setValues(placer.m_6350_().m_122424_(), new BlockPos(compound.m_128451_("controllerX"), compound.m_128451_("controllerY"), compound.m_128451_("controllerZ")));
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("controllerDim")) {
            tooltip.add((Component)TextComponents.translation((String)"movingelevators.remote_controller.tooltip").color(ChatFormatting.AQUA).get());
        } else {
            MutableComponent x = TextComponents.number((int)tag.m_128451_("controllerX")).color(ChatFormatting.GOLD).get();
            MutableComponent y = TextComponents.number((int)tag.m_128451_("controllerY")).color(ChatFormatting.GOLD).get();
            MutableComponent z = TextComponents.number((int)tag.m_128451_("controllerZ")).color(ChatFormatting.GOLD).get();
            MutableComponent dimension = TextComponents.dimension((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("controllerDim")))).color(ChatFormatting.GOLD).get();
            tooltip.add((Component)TextComponents.translation((String)"movingelevators.remote_controller.tooltip.bound", (Object[])new Object[]{x, y, z, dimension}).get());
        }
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        Object entity = world.m_7702_(pos);
        if (entity instanceof RemoteControllerBlockEntity && (entity = ((RemoteControllerBlockEntity)((Object)entity)).getController()) != null && ((ControllerBlockEntity)((Object)entity)).hasGroup() && ((ControllerBlockEntity)((Object)entity)).getGroup().isCageAvailableAt((ControllerBlockEntity)((Object)entity))) {
            return 15;
        }
        return 0;
    }
}

