/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RemoteControllerBlockEntity
extends ElevatorInputBlockEntity {
    private Direction facing = Direction.NORTH;
    private BlockPos controllerPos = BlockPos.f_121853_;
    private int groupCheckCounter = 0;
    private ElevatorGroup lastGroup;

    public RemoteControllerBlockEntity(BlockPos pos, BlockState state) {
        super(MovingElevators.button_tile, pos, state);
    }

    @Override
    public void tick() {
        ElevatorGroup group;
        super.tick();
        ++this.groupCheckCounter;
        if (this.groupCheckCounter == 40 && (group = this.getGroup()) != this.lastGroup) {
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            group.addComparatorListener(this.getFloorLevel(), this.f_58858_);
            this.lastGroup = group;
        }
    }

    public void setValues(Direction facing, BlockPos controllerPos) {
        this.facing = facing;
        this.controllerPos = controllerPos;
        this.dataChanged();
    }

    @Override
    protected CompoundTag writeData() {
        CompoundTag compound = super.writeData();
        compound.m_128405_("facing", this.facing.m_122411_());
        compound.m_128405_("controllerX", this.controllerPos.m_123341_());
        compound.m_128405_("controllerY", this.controllerPos.m_123342_());
        compound.m_128405_("controllerZ", this.controllerPos.m_123343_());
        return compound;
    }

    @Override
    protected void readData(CompoundTag compound) {
        super.readData(compound);
        this.facing = Direction.m_122376_((int)compound.m_128451_("facing"));
        this.controllerPos = new BlockPos(compound.m_128451_("controllerX"), compound.m_128451_("controllerY"), compound.m_128451_("controllerZ"));
    }

    @Override
    public Direction getFacing() {
        return this.facing;
    }

    public ControllerBlockEntity getController() {
        if (this.f_58857_ == null || this.controllerPos == null) {
            return null;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.controllerPos);
        return tile instanceof ControllerBlockEntity ? (ControllerBlockEntity)tile : null;
    }

    @Override
    public boolean hasGroup() {
        ControllerBlockEntity controller = this.getController();
        return controller != null && controller.hasGroup();
    }

    @Override
    public ElevatorGroup getGroup() {
        ControllerBlockEntity controller = this.getController();
        return controller == null ? null : controller.getGroup();
    }

    @Override
    public String getFloorName() {
        ControllerBlockEntity controller = this.getController();
        return controller == null ? null : controller.getFloorName();
    }

    @Override
    public DyeColor getDisplayLabelColor() {
        ControllerBlockEntity controller = this.getController();
        return controller == null ? null : controller.getDisplayLabelColor();
    }

    @Override
    public int getFloorLevel() {
        return this.controllerPos.m_123342_();
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void m_7651_() {
        ElevatorGroup group = this.getGroup();
        if (group != null) {
            group.removeComparatorListener(this.f_58858_);
        }
        super.m_7651_();
    }
}

