/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.packets.PacketAddElevatorGroup;
import com.supermartijn642.movingelevators.packets.PacketRemoveElevatorGroup;
import com.supermartijn642.movingelevators.packets.PacketUpdateElevatorGroups;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ElevatorGroupCapability {
    public static Capability<ElevatorGroupCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ElevatorGroupCapability>(){});
    private final Level world;
    private final Map<ElevatorGroupPosition, ElevatorGroup> groups = new HashMap<ElevatorGroupPosition, ElevatorGroup>();

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent e) {
        e.register(ElevatorGroupCapability.class);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Level> e) {
        Level world = (Level)e.getObject();
        final LazyOptional capability = LazyOptional.of(() -> new ElevatorGroupCapability(world));
        e.addCapability(new ResourceLocation("movingelevators", "elevator_groups"), (ICapabilityProvider)new ICapabilitySerializable<Tag>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CAPABILITY ? capability.cast() : LazyOptional.empty();
            }

            public Tag serializeNBT() {
                return capability.map(ElevatorGroupCapability::write).orElse(null);
            }

            public void deserializeNBT(Tag nbt) {
                capability.ifPresent(capability -> capability.read(nbt));
            }
        });
        e.addListener(() -> ((LazyOptional)capability).invalidate());
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        ElevatorGroupCapability.tickWorldCapability(e.world);
    }

    public static void tickWorldCapability(Level world) {
        world.getCapability(CAPABILITY).ifPresent(ElevatorGroupCapability::tick);
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerChangedDimensionEvent e) {
        ServerPlayer player = (ServerPlayer)e.getPlayer();
        player.f_19853_.getCapability(CAPABILITY).ifPresent(groups -> MovingElevators.CHANNEL.sendToPlayer((Player)player, (BasePacket)new PacketUpdateElevatorGroups(groups.write())));
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        ServerPlayer player = (ServerPlayer)e.getPlayer();
        player.f_19853_.getCapability(CAPABILITY).ifPresent(groups -> MovingElevators.CHANNEL.sendToPlayer((Player)player, (BasePacket)new PacketUpdateElevatorGroups(groups.write())));
    }

    public ElevatorGroupCapability(Level world) {
        this.world = world;
    }

    public ElevatorGroupCapability() {
        this.world = null;
    }

    public ElevatorGroup get(int x, int z, Direction facing) {
        return this.groups.get(new ElevatorGroupPosition(x, z, facing));
    }

    public void add(ControllerBlockEntity controller) {
        ElevatorGroupPosition pos = new ElevatorGroupPosition(controller.m_58899_(), controller.getFacing());
        this.groups.putIfAbsent(pos, new ElevatorGroup(this.world, pos.x, pos.z, pos.facing));
        this.groups.get(pos).add(controller);
    }

    public void remove(ControllerBlockEntity controller) {
        ElevatorGroupPosition pos = new ElevatorGroupPosition(controller.m_58899_(), controller.getFacing());
        ElevatorGroup group = this.groups.get(pos);
        group.remove(controller);
        if (group.getFloorCount() == 0) {
            this.groups.remove(pos);
            MovingElevators.CHANNEL.sendToDimension(this.world.m_46472_(), (BasePacket)new PacketRemoveElevatorGroup(group));
        }
    }

    public void tick() {
        for (ElevatorGroup group : this.groups.values()) {
            group.update();
        }
    }

    public void updateGroup(ElevatorGroup group) {
        if (!this.world.f_46443_ && group != null) {
            MovingElevators.CHANNEL.sendToDimension(this.world.m_46472_(), (BasePacket)new PacketAddElevatorGroup(this.writeGroup(group)));
        }
    }

    public void removeGroup(int x, int z, Direction facing) {
        if (this.world.f_46443_) {
            this.groups.remove(new ElevatorGroupPosition(x, z, facing));
        }
    }

    public ElevatorGroup getGroup(ControllerBlockEntity tile) {
        return this.groups.get(new ElevatorGroupPosition(tile.m_58899_().m_123341_(), tile.m_58899_().m_123343_(), tile.getFacing()));
    }

    public Collection<ElevatorGroup> getGroups() {
        return this.groups.values();
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        for (Map.Entry<ElevatorGroupPosition, ElevatorGroup> entry : this.groups.entrySet()) {
            CompoundTag groupTag = new CompoundTag();
            groupTag.m_128365_("group", (Tag)entry.getValue().write());
            groupTag.m_128365_("pos", (Tag)entry.getKey().write());
            compound.m_128365_(entry.getKey().x + ";" + entry.getKey().z, (Tag)groupTag);
        }
        return compound;
    }

    public void read(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            this.groups.clear();
            for (String key : compound.m_128431_()) {
                CompoundTag groupTag = compound.m_128469_(key);
                if (!groupTag.m_128441_("group") || !groupTag.m_128441_("pos")) continue;
                ElevatorGroupPosition pos = ElevatorGroupPosition.read(groupTag.m_128469_("pos"));
                ElevatorGroup group = new ElevatorGroup(this.world, pos.x, pos.z, pos.facing);
                group.read(groupTag.m_128469_("group"));
                this.groups.put(pos, group);
            }
        }
    }

    private CompoundTag writeGroup(ElevatorGroup group) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("group", (Tag)group.write());
        tag.m_128365_("pos", (Tag)new ElevatorGroupPosition(group.x, group.z, group.facing).write());
        return tag;
    }

    public void readGroup(CompoundTag tag) {
        if (tag.m_128441_("group") && tag.m_128441_("pos")) {
            ElevatorGroupPosition pos = ElevatorGroupPosition.read(tag.m_128469_("pos"));
            ElevatorGroup group = new ElevatorGroup(this.world, pos.x, pos.z, pos.facing);
            group.read(tag.m_128469_("group"));
            this.groups.put(pos, group);
        }
    }

    private static class ElevatorGroupPosition {
        public final int x;
        public final int z;
        public final Direction facing;

        private ElevatorGroupPosition(int x, int z, Direction facing) {
            this.x = x;
            this.z = z;
            this.facing = facing;
        }

        public ElevatorGroupPosition(BlockPos pos, Direction facing) {
            this(pos.m_123341_(), pos.m_123343_(), facing);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElevatorGroupPosition that = (ElevatorGroupPosition)o;
            if (this.x != that.x) {
                return false;
            }
            if (this.z != that.z) {
                return false;
            }
            return this.facing == that.facing;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.z;
            result = 31 * result + (this.facing != null ? this.facing.hashCode() : 0);
            return result;
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", this.x);
            tag.m_128405_("z", this.z);
            tag.m_128405_("facing", this.facing.m_122416_());
            return tag;
        }

        public static ElevatorGroupPosition read(CompoundTag tag) {
            return new ElevatorGroupPosition(tag.m_128451_("x"), tag.m_128451_("z"), Direction.m_122407_((int)tag.m_128451_("facing")));
        }
    }
}

