/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.gui.preview.ElevatorPreviewRenderer;
import com.supermartijn642.movingelevators.gui.preview.WorldBlockCapture;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.AABB;

public class ElevatorPreviewWidget
extends Widget {
    private final Supplier<ControllerBlockEntity> elevatorEntity;
    private final Supplier<BlockPos> previewSizeIncrease;
    private final Supplier<BlockPos> previewOffset;
    private final Supplier<Float> guiLeft;
    private final Supplier<Float> guiTop;
    private float yaw = 20.0f;
    private float pitch = 30.0f;
    private boolean dragging = false;
    private int mouseStartX;
    private int mouseStartY;

    public ElevatorPreviewWidget(int x, int y, int width, int height, Supplier<ControllerBlockEntity> elevatorEntity, Supplier<BlockPos> previewSizeIncrease, Supplier<BlockPos> previewOffset, Supplier<Float> guiLeft, Supplier<Float> guiTop) {
        super(x, y, width, height);
        this.elevatorEntity = elevatorEntity;
        this.previewSizeIncrease = previewSizeIncrease;
        this.previewOffset = previewOffset;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
    }

    protected Component getNarrationMessage() {
        return null;
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.dragging) {
            this.yaw = (float)((double)this.yaw + (double)(mouseX - this.mouseStartX) / 100.0 * 360.0);
            this.pitch = (float)((double)this.pitch + (double)(mouseY - this.mouseStartY) / 100.0 * 360.0);
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
        }
        ControllerBlockEntity elevatorEntity = this.elevatorEntity.get();
        ElevatorGroup group = elevatorEntity.getGroup();
        BlockPos anchorPos = group.getCageAnchorBlockPos(elevatorEntity.m_58899_().m_123342_());
        WorldBlockCapture capture = new WorldBlockCapture(group.world);
        capture.putBlock(elevatorEntity.m_58899_(), elevatorEntity.m_58899_());
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    BlockPos pos = anchorPos.m_142082_(x, y, z);
                    capture.putBlock(pos, pos);
                }
            }
        }
        AABB cabinBox = new AABB(anchorPos, anchorPos.m_142082_(group.getCageSizeX(), group.getCageSizeY(), group.getCageSizeZ())).m_82400_(0.1);
        BlockPos previewSizeIncrease = this.previewSizeIncrease.get();
        BlockPos previewOffset = this.previewOffset.get();
        AABB previewBox = null;
        if (!previewSizeIncrease.equals((Object)BlockPos.f_121853_) || !previewOffset.equals((Object)BlockPos.f_121853_)) {
            int cabinWidth = group.getCageWidth() + previewSizeIncrease.m_123341_();
            int cabinDepth = group.getCageDepth() + previewSizeIncrease.m_123343_();
            int cabinHeight = group.getCageHeight() + previewSizeIncrease.m_123342_();
            int sideOffset = group.getCageSideOffset() + previewOffset.m_123341_();
            int depthOffset = group.getCageDepthOffset() + previewOffset.m_123343_();
            int heightOffset = group.getCageHeightOffset() + previewOffset.m_123342_();
            if (sideOffset > 2 + (group.facing == Direction.NORTH || group.facing == Direction.WEST ? (cabinWidth - 1) / 2 : (int)Math.ceil((float)(cabinWidth - 1) / 2.0f))) {
                sideOffset = 2 + (group.facing == Direction.NORTH || group.facing == Direction.WEST ? (cabinWidth - 1) / 2 : (int)Math.ceil((float)(cabinWidth - 1) / 2.0f));
            } else if (sideOffset < -2 - (group.facing == Direction.NORTH || group.facing == Direction.WEST ? (int)Math.ceil((float)(cabinWidth - 1) / 2.0f) : (cabinWidth - 1) / 2)) {
                sideOffset = -2 - (group.facing == Direction.NORTH || group.facing == Direction.WEST ? (int)Math.ceil((float)(cabinWidth - 1) / 2.0f) : (cabinWidth - 1) / 2);
            }
            if (heightOffset < -cabinHeight) {
                heightOffset = -cabinHeight;
            }
            int anchorX = 0;
            int anchorY = elevatorEntity.m_58899_().m_123342_();
            int anchorZ = 0;
            if (group.facing == Direction.NORTH) {
                anchorX = group.x - cabinWidth / 2 - sideOffset;
                anchorZ = group.z - cabinDepth - depthOffset;
            } else if (group.facing == Direction.SOUTH) {
                anchorX = group.x - cabinWidth / 2 + sideOffset;
                anchorZ = group.z + 1 + depthOffset;
            } else if (group.facing == Direction.WEST) {
                anchorX = group.x - cabinDepth - depthOffset;
                anchorZ = group.z - cabinWidth / 2 + sideOffset;
            } else if (group.facing == Direction.EAST) {
                anchorX = group.x + 1 + depthOffset;
                anchorZ = group.z - cabinWidth / 2 - sideOffset;
            }
            previewBox = new AABB((double)anchorX, (double)(anchorY += heightOffset), (double)anchorZ, (double)(anchorX + (group.facing.m_122434_() == Direction.Axis.X ? cabinDepth : cabinWidth)), (double)(anchorY + cabinHeight), (double)(anchorZ + (group.facing.m_122434_() == Direction.Axis.Z ? cabinDepth : cabinWidth))).m_82400_(0.1);
        }
        ElevatorPreviewRenderer.renderPreview(capture, cabinBox, previewBox, (float)this.x + (float)this.width / 2.0f + this.guiLeft.get().floatValue(), (float)this.y + (float)this.height / 2.0f + this.guiTop.get().floatValue(), Math.min(this.width, this.height), this.yaw + group.facing.m_122435_(), this.pitch, false);
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            this.dragging = true;
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int button) {
        this.dragging = false;
    }
}

