/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.element.MapElement;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.mods.SupportMods;

public class MapElementRenderHandler {
    private final List<MapElementRenderer<?, ?>> renderers;

    private MapElementRenderHandler(List<MapElementRenderer<?, ?>> renderers) {
        this.renderers = renderers;
    }

    public MapElement<?> render(GuiMap mapScreen, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double scale, double mouseX, double mouseZ, float brightness, MapElement<?> oldHovered, Minecraft mc) {
        VertexConsumer regularUIObjectConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.GUI_BILINEAR);
        MapElement<?> hovered = null;
        MapElementRenderer<?, ?> hoveredRenderer = null;
        TextureManager textureManager = mc.m_91097_();
        Font fontRenderer = mc.f_91062_;
        textureManager.m_174784_(WorldMap.guiTextures);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        double baseScale = guiBasedScale / scale;
        for (int i = this.renderers.size() - 1; i >= 0; --i) {
            MapElementRenderer<?, ?> renderer = this.renderers.get(i);
            Object rendererHovered = renderer.getHovered(mapScreen, mouseX, mouseZ, scale, guiBasedScale);
            if (rendererHovered == null) continue;
            hovered = rendererHovered;
            hoveredRenderer = renderer;
            break;
        }
        MapElement<?> hoveredToReturn = hovered;
        if (hovered == null && (hovered = oldHovered) != null) {
            hoveredRenderer = (MapElementRenderer<?, ?>)hovered.getRenderer();
        }
        VertexConsumer textBGConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
        MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.m_157453_((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
        for (MapElementRenderer<?, ?> renderer : this.renderers) {
            renderer.renderPre(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, oldHovered, mc, textBGConsumer);
        }
        rendererProvider.draw(uniqueTextureUIObjectRenderer);
        renderTypeBuffers.m_109911_();
        if (hovered != null) {
            regularUIObjectConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.GUI_BILINEAR);
            textBGConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
            uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.m_157453_((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
            hoveredRenderer.renderHoveredPre(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, mc, textBGConsumer);
            rendererProvider.draw(uniqueTextureUIObjectRenderer);
            renderTypeBuffers.m_109911_();
        }
        regularUIObjectConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.GUI_BILINEAR);
        textBGConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
        uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.m_157453_((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
        for (MapElementRenderer<?, ?> renderer : this.renderers) {
            renderer.render(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, oldHovered, mc, textBGConsumer);
        }
        rendererProvider.draw(uniqueTextureUIObjectRenderer);
        renderTypeBuffers.m_109911_();
        if (hovered != null) {
            regularUIObjectConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.GUI_BILINEAR);
            textBGConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
            uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.m_157453_((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
            hoveredRenderer.renderHovered(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, mc, textBGConsumer);
            rendererProvider.draw(uniqueTextureUIObjectRenderer);
            renderTypeBuffers.m_109911_();
        }
        textureManager.m_174784_(WorldMap.guiTextures);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        return hoveredToReturn;
    }

    public static final class Builder {
        private Builder() {
        }

        public MapElementRenderHandler build() {
            ArrayList renderers = new ArrayList();
            if (SupportMods.minimap()) {
                renderers.add(SupportMods.xaeroMinimap.getWaypointRenderer());
            }
            return new MapElementRenderHandler(renderers);
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

