/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class CursorBox {
    private static final int BOX_OFFSET_X = 12;
    private static final int BOX_OFFSET_Y = -10;
    private static final int START_WIDTH = 20;
    private static final int USUAL_WIDTH = 200;
    private ArrayList<Component> strings;
    private Component directText;
    private boolean directTextReady;
    private String language;
    private String fullCode;
    private Style codeStyle;
    private String plainText;
    private int boxWidth = 20;
    private static final int color = -939524096;
    private boolean customLines;
    private boolean flippedByDefault;
    private boolean autoLinebreak;

    public CursorBox(String code) {
        this(code, Style.f_131099_);
    }

    public CursorBox(String code, Style codeStyle) {
        this(code, codeStyle, false);
    }

    public CursorBox(String code, Style codeStyle, boolean flippedByDefault) {
        this.fullCode = code;
        this.codeStyle = codeStyle;
        this.flippedByDefault = flippedByDefault;
        this.autoLinebreak = true;
    }

    public CursorBox(Component directText) {
        this(directText, false);
    }

    public CursorBox(Component directText, boolean flippedByDefault) {
        this.directText = directText;
        this.flippedByDefault = flippedByDefault;
        this.autoLinebreak = true;
    }

    public CursorBox(int size) {
        this.strings = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.strings.add((Component)new TextComponent(""));
        }
        this.customLines = true;
    }

    public void setBoxWidth(int boxWidth) {
        this.boxWidth = boxWidth;
    }

    private String currentLanguage() {
        return Minecraft.m_91087_().m_91102_().m_118983_().getCode();
    }

    public void createLines(Component text) {
        try {
            this.language = this.currentLanguage();
        }
        catch (NullPointerException e) {
            this.language = "en_us";
        }
        this.strings = new ArrayList();
        SplitProgress progress = new SplitProgress();
        int spaceWidth = Minecraft.m_91087_().f_91062_.m_92895_(" ");
        this.splitWords(this.strings, progress, spaceWidth, (FormattedText)text);
    }

    public void splitWords(ArrayList<Component> dest, SplitProgress progress, int spaceWidth, FormattedText formattedText) {
        StringBuilder plainTextBuilder = new StringBuilder();
        FormattedText.StyledContentConsumer consumer = (style, text) -> {
            plainTextBuilder.append(text);
            boolean endsWithSpace = ((String)text).endsWith(" ");
            if (endsWithSpace) {
                text = (String)text + ".";
            }
            String[] parts = ((String)text).split(" ");
            boolean isEnd = style == null;
            int widthLimit = this.autoLinebreak ? 200 : Integer.MAX_VALUE;
            for (int i = 0; i < parts.length; ++i) {
                boolean isNewLine;
                boolean canAddMultiword = isEnd || i < parts.length - 1;
                String part = isEnd || endsWithSpace && i == parts.length - 1 ? "" : parts[i];
                int partWidth = Minecraft.m_91087_().f_91062_.m_92895_(part);
                if (!canAddMultiword) {
                    progress.buildMultiword(part, partWidth, style);
                    continue;
                }
                int wordWidth = partWidth + progress.multiwordWidth;
                int wordTakesWidth = wordWidth + (!progress.firstWord ? spaceWidth : 0);
                if (progress.lineWidth + wordTakesWidth <= widthLimit - 20) {
                    this.boxWidth = Math.max(this.boxWidth, Math.min(widthLimit, progress.lineWidth + wordTakesWidth + 20));
                }
                if (progress.firstWord && progress.lineWidth + wordTakesWidth > this.boxWidth - 20) {
                    this.boxWidth = progress.lineWidth + wordTakesWidth + 20;
                }
                boolean bl = isNewLine = progress.multiword == null && part.equals("\n");
                if (!isNewLine && progress.lineWidth + wordTakesWidth <= this.boxWidth - 20) {
                    progress.confirmWord(part, style, wordTakesWidth);
                    continue;
                }
                progress.confirmComponent();
                dest.add(progress.line);
                progress.nextLine();
                if (isNewLine) continue;
                --i;
            }
            return Optional.empty();
        };
        formattedText.m_7451_(consumer, Style.f_131099_.m_131140_(ChatFormatting.WHITE));
        if (progress.multiword != null) {
            consumer.m_7164_(null, "end");
        } else if (progress.stringBuilder.length() > 0) {
            progress.confirmComponent();
        }
        if (progress.line != null) {
            dest.add(progress.line);
        }
        if (this.boxWidth > 20) {
            --this.boxWidth;
        }
        this.plainText = plainTextBuilder.toString();
    }

    public Component getLine(int line) {
        return this.strings.get(line);
    }

    private void ensure() {
        try {
            if (!(this.customLines || (this.fullCode != null || this.directTextReady) && this.language != null && this.language.equals(this.currentLanguage()))) {
                if (this.fullCode != null) {
                    this.createLines((Component)new TranslatableComponent(this.fullCode).m_130948_(this.codeStyle));
                } else {
                    this.createLines(this.directText);
                    this.directTextReady = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawBox(PoseStack matrixStack, int x, int y, int width, int height) {
        int h;
        int overEdgeY;
        this.ensure();
        int drawX = x + 12;
        int drawY = y + -10;
        int overEdgeX = drawX + this.boxWidth - width;
        if (this.flippedByDefault || overEdgeX > 9) {
            drawX = x - 12 - this.boxWidth;
        } else if (overEdgeX > 0) {
            drawX -= overEdgeX;
        }
        if (drawX < 0) {
            drawX = 0;
        }
        if ((overEdgeY = drawY + (h = 5 + this.strings.size() * 10 + 5) - height) > h / 2) {
            drawY = y - -10 - h;
        } else if (overEdgeY > 0) {
            drawY -= overEdgeY;
        }
        if (drawY < 0) {
            drawY = 0;
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)drawX, (int)drawY, (int)(drawX + this.boxWidth), (int)(drawY + h), (int)-939524096);
        for (int i = 0; i < this.strings.size(); ++i) {
            Component s = this.getLine(i);
            Minecraft.m_91087_().f_91062_.m_92889_(matrixStack, s, (float)(drawX + 10), (float)(drawY + 6 + 10 * i), 0xFFFFFF);
        }
    }

    public CursorBox withWidth(int boxWidth) {
        this.boxWidth = boxWidth;
        return this;
    }

    public void setAutoLinebreak(boolean autoLinebreak) {
        this.autoLinebreak = autoLinebreak;
    }

    public String getPlainText() {
        this.ensure();
        return this.plainText;
    }

    public String getFullCode() {
        return this.fullCode;
    }

    public class SplitProgress {
        int multiwordWidth;
        List<MutableComponent> multiword = null;
        boolean firstWord = true;
        Component line = null;
        StringBuilder stringBuilder = new StringBuilder();
        int lineWidth;
        Style lastStyle;

        public void buildMultiword(String wordPart, int width, Style style) {
            MutableComponent wordPartComponent = new TextComponent(wordPart).m_130948_(style);
            if (this.multiword == null) {
                this.multiword = new ArrayList<MutableComponent>();
            }
            this.multiword.add(wordPartComponent);
            this.multiwordWidth += width;
        }

        private void confirmWordPart(String part, Style style) {
            if (this.lastStyle != null && !Objects.equals(style, this.lastStyle)) {
                this.confirmComponent();
            }
            this.stringBuilder.append(part);
            this.lastStyle = style;
        }

        public void confirmWord(String lastPart, Style lastPartStyle, int width) {
            if (!this.firstWord) {
                this.stringBuilder.append(" ");
            }
            if (this.multiword != null) {
                for (Component component : this.multiword) {
                    String text = component.m_6111_();
                    Style style = component.m_7383_();
                    this.confirmWordPart(text, style);
                }
                this.multiword = null;
                this.multiwordWidth = 0;
            }
            this.confirmWordPart(lastPart, lastPartStyle);
            this.lineWidth += width;
            this.firstWord = false;
        }

        public void confirmComponent() {
            MutableComponent comp = new TextComponent(this.stringBuilder.toString()).m_130948_(this.lastStyle == null ? Style.f_131099_ : this.lastStyle);
            if (this.line != null) {
                if (this.stringBuilder.length() > 0) {
                    this.line.m_7360_().add(comp);
                }
            } else {
                this.line = comp;
            }
            this.stringBuilder.delete(0, this.stringBuilder.length());
        }

        public void nextLine() {
            this.firstWord = true;
            this.line = null;
            this.lastStyle = null;
            this.lineWidth = 0;
        }
    }
}

