/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.MapElement;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.gui.GuiMap;
import xaero.map.icon.XaeroIcon;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportXaeroMinimap;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointSymbolCreator;

public class WaypointRenderer
extends MapElementRenderer<Waypoint, WaypointRenderer> {
    private final SupportXaeroMinimap minimap;
    private final WaypointSymbolCreator symbolCreator;

    public WaypointRenderer(SupportXaeroMinimap minimap, WaypointSymbolCreator symbolCreator) {
        this.minimap = minimap;
        this.symbolCreator = symbolCreator;
    }

    @Override
    public double getRendererScale() {
        return WorldMap.settings.worldmapWaypointsScale;
    }

    public WaypointSymbolCreator getSymbolCreator() {
        return this.symbolCreator;
    }

    @Override
    public Iterator<Waypoint> getElementsToRender() {
        if (!WorldMap.settings.waypoints) {
            return new ArrayList().iterator();
        }
        return this.minimap.getWaypoints().iterator();
    }

    public boolean waypointIsGood(Waypoint w, GuiMap mapScreen) {
        return (w.getType() != 1 && w.getType() != 2 || this.minimap.getDeathpoints()) && (w.isGlobal() || mapScreen.getUserScale() >= WorldMap.settings.minZoomForLocalWaypoints);
    }

    private void renderShadow(Waypoint e, PoseStack matrixStack, double cameraX, double cameraZ, double globalElementScale, TextureManager textureManager, VertexConsumer regularUIObjectConsumer, float brightness) {
        float elementScale = (float)(globalElementScale * e.getScale());
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)(e.getRenderX() - cameraX)), (double)((float)(e.getRenderZ() - cameraZ)), 0.0);
        matrixStack.m_85841_(elementScale, elementScale, 1.0f);
        e.renderShadow(brightness, regularUIObjectConsumer, matrixStack, textureManager);
        matrixStack.m_85849_();
    }

    @Override
    public void renderPre(MapElement<?> hovered, GuiMap mapScreen, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers, VertexConsumer regularUIObjectConsumer, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, TextureManager textureManager, Font font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, MapElement<?> oldHovered, Minecraft mc, VertexConsumer textBGConsumer) {
        super.renderPre(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, font, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, oldHovered, mc, textBGConsumer);
        if (WorldMap.settings.waypointBackgrounds) {
            double globalElementScale = baseScale * this.getRendererScale();
            Iterator<Waypoint> elements = this.getElementsToRender();
            while (elements.hasNext()) {
                Waypoint e = elements.next();
                if (e.isHidden((WaypointRenderer)this.self, mapScreen) || e == hovered || !e.isOnScreen(cameraX, cameraZ, width, height, scale)) continue;
                this.renderShadow(e, matrixStack, cameraX, cameraZ, globalElementScale, textureManager, regularUIObjectConsumer, brightness);
            }
        }
    }

    @Override
    public void renderHoveredPre(MapElement<?> hovered, GuiMap mapScreen, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers, VertexConsumer regularUIObjectConsumer, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, TextureManager textureManager, Font font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, Minecraft mc, VertexConsumer textBGConsumer) {
        super.renderHoveredPre(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, font, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, mc, textBGConsumer);
        double globalElementScale = baseScale * this.getRendererScale();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 10.0);
        this.renderShadow((Waypoint)hovered, matrixStack, cameraX, cameraZ, globalElementScale, textureManager, regularUIObjectConsumer, brightness);
        matrixStack.m_85849_();
    }

    @Override
    public void renderOnMap(Waypoint w, boolean hovered, Minecraft mc, PoseStack matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, double scale, double guiBasedScale, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, TextureManager textureManager, Font fontRenderer, VertexConsumer textBGConsumer, MultiBufferSource.BufferSource renderTypeBuffers, WaypointRenderer renderer) {
        int symbolFrameWidth;
        boolean renderBackground = hovered || WorldMap.settings.waypointBackgrounds;
        matrixStack.m_85836_();
        float visibilityAlpha = w.isDisabled() ? 0.3f : 1.0f;
        int color = w.getColor();
        String symbol = w.getSymbol();
        int type = w.getType();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int flagU = 35;
        int flagV = 34;
        int flagW = 30;
        int flagH = 43;
        if (symbol.length() > 1) {
            flagU += 35;
            flagW += 13;
        }
        if (w.isTemporary()) {
            flagU += 83;
        }
        matrixStack.m_85837_((double)((float)(-flagW) / 2.0f), (double)(-flagH + 1), 0.0);
        if (renderBackground) {
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.m_85850_().m_85861_(), uniqueTextureUIObjectRenderer, 0, 0, flagU, flagV, flagW, flagH, red * visibilityAlpha, green * visibilityAlpha, blue * visibilityAlpha, visibilityAlpha, textureManager.m_118506_(WorldMap.guiTextures).m_117963_());
        }
        matrixStack.m_85849_();
        float oldDestAlpha = w.getDestAlpha();
        if (hovered) {
            w.setDestAlpha(255.0f);
        } else {
            w.setDestAlpha(0.0f);
        }
        if (oldDestAlpha != w.getDestAlpha()) {
            w.setAlphaAnim(new SlowingAnimation(w.getAlpha(), w.getDestAlpha(), 0.8, 1.0));
        }
        if (w.getAlphaAnim() != null) {
            w.setAlpha((float)w.getAlphaAnim().getCurrent());
        }
        float alpha = w.getAlpha();
        XaeroIcon symbolIcon = null;
        int symbolVerticalOffset = 0;
        int symbolWidth = 0;
        int stringWidth = fontRenderer.m_92895_(symbol);
        int n = symbolFrameWidth = stringWidth / 2 > 4 ? 62 : 32;
        if (type != 1 && alpha < 200.0f) {
            symbolVerticalOffset = 5;
            symbolWidth = (stringWidth - 1) * 3;
            symbolIcon = renderer.getSymbolCreator().getSymbolTexture(symbol);
        } else if (type == 1) {
            symbolVerticalOffset = 3;
            symbolWidth = 27;
            symbolIcon = renderer.getSymbolCreator().getDeathSymbolTexture();
        }
        if (symbolIcon != null) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(-1.0f - (float)symbolWidth / 2.0f), (double)(62 + (renderBackground ? -43 + symbolVerticalOffset - 1 : -12)), 0.0);
            matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.m_85850_().m_85861_(), uniqueTextureUIObjectRenderer, 0, 0, symbolIcon.getOffsetX() + 1, symbolIcon.getOffsetY() + 1, symbolFrameWidth, 62, visibilityAlpha, visibilityAlpha, visibilityAlpha, visibilityAlpha, symbolIcon.getTextureAtlas().getWidth(), symbolIcon.getTextureAtlas().getWidth(), symbolIcon.getTextureAtlas().getTextureId());
            matrixStack.m_85849_();
        }
        if ((int)alpha > 0) {
            int tc = (int)alpha << 24 | 0xFFFFFF;
            String name = w.getName();
            int len = fontRenderer.m_92895_(name);
            matrixStack.m_85837_(0.0, (double)(renderBackground ? -38 : -11), 0.0);
            matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
            int bgLen = Math.max(len + 2, 10);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), textBGConsumer, -bgLen / 2, -1, bgLen / 2, 9, red, green, blue, alpha / 255.0f);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), textBGConsumer, -bgLen / 2, -1, bgLen / 2, 8, 0.0f, 0.0f, 0.0f, alpha / 255.0f * 200.0f / 255.0f);
            if ((int)alpha > 3) {
                matrixStack.m_85837_(0.0, 0.0, 1.0);
                Misc.drawNormalText(matrixStack, name, (float)(-(len - 1)) / 2.0f, 0.0f, tc, false, renderTypeBuffers);
            }
        }
    }
}

