/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientRegion;
import team.creative.ambientsounds.AmbientSound;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.env.AmbientEnviroment;
import team.creative.ambientsounds.sound.AmbientSoundEngine;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.reflection.ReflectionHelper;

public class AmbientTickHandler {
    private static Minecraft mc = Minecraft.m_91087_();
    public AmbientSoundEngine soundEngine;
    public AmbientEnviroment enviroment = null;
    public AmbientEngine engine;
    public int timer = 0;
    public boolean showDebugInfo = false;
    public static final DecimalFormat df = new DecimalFormat("0.##");

    public void setEngine(AmbientEngine engine) {
        this.engine = engine;
        this.initConfiguration();
    }

    public void initConfiguration() {
        CreativeConfigRegistry.ROOT.removeField("ambientsounds");
        if (this.engine == null) {
            return;
        }
        ConfigHolderDynamic holder = CreativeConfigRegistry.ROOT.registerFolder("ambientsounds", ConfigSynchronization.CLIENT);
        ConfigHolderDynamic sounds = holder.registerFolder("sounds");
        Field soundField = ReflectionHelper.findField(AmbientSound.class, (String)"volumeSetting", (String)"volumeSetting");
        for (Map.Entry<String, AmbientRegion> pair : this.engine.allRegions.entrySet()) {
            if (pair.getValue().sounds == null) continue;
            for (AmbientSound sound : pair.getValue().sounds.values()) {
                sounds.registerField(pair.getKey() + "." + sound.name, soundField, (Object)sound);
            }
        }
        ConfigHolderDynamic dimensions = holder.registerFolder("dimensions");
        Field dimensionField = ReflectionHelper.findField(AmbientDimension.class, (String)"volumeSetting", (String)"volumeSetting");
        for (AmbientDimension dimension : this.engine.dimensions.values()) {
            dimensions.registerField(dimension.name, dimensionField, (Object)dimension);
        }
        holder.registerField("silent-dimensions", ReflectionHelper.findField(AmbientEngine.class, (String)"silentDimensions", (String)"silentDimensions"), (Object)this.engine);
        holder.registerValue("general", (Object)AmbientSounds.CONFIG);
        CreativeCore.CONFIG_HANDLER.load("ambientsounds", Side.CLIENT);
    }

    private String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return df.format(value);
        }
        return value.toString();
    }

    private String format(List<Pair<String, Object>> details) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Pair<String, Object> pair : details) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            builder.append(ChatFormatting.YELLOW + (String)pair.key + ChatFormatting.RESET + ":" + this.format(pair.value));
        }
        return builder.toString();
    }

    public void onRender() {
        if (this.showDebugInfo && this.engine != null && !mc.m_91104_() && this.enviroment != null && AmbientTickHandler.mc.f_91073_ != null) {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<Pair<String, Object>> details = new ArrayList<Pair<String, Object>>();
            this.engine.collectDetails(details);
            details.add((Pair<String, Object>)new Pair((Object)"playing", (Object)this.engine.soundEngine.playingCount()));
            details.add((Pair<String, Object>)new Pair((Object)"dim-name", (Object)AmbientTickHandler.mc.f_91073_.m_46472_().m_135782_()));
            list.add(this.format(details));
            details.clear();
            this.enviroment.collectLevelDetails(details);
            list.add(this.format(details));
            details.clear();
            this.enviroment.collectPlayerDetails(details, (Player)AmbientTickHandler.mc.f_91074_);
            list.add(this.format(details));
            details.clear();
            this.enviroment.collectTerrainDetails(details);
            list.add(this.format(details));
            details.clear();
            this.enviroment.collectBiomeDetails(details);
            list.add(this.format(details));
            details.clear();
            for (AmbientRegion region : this.engine.activeRegions) {
                details.add((Pair<String, Object>)new Pair((Object)"region", (Object)(ChatFormatting.DARK_GREEN + region.name + ChatFormatting.RESET)));
                details.add((Pair<String, Object>)new Pair((Object)"playing", (Object)region.playing.size()));
                list.add(this.format(details));
                details.clear();
                for (AmbientSound sound : region.playing) {
                    if (!sound.isPlaying()) continue;
                    Object text = "";
                    if (sound.stream1 != null) {
                        details.add((Pair<String, Object>)new Pair((Object)"n", (Object)sound.stream1.location));
                        details.add((Pair<String, Object>)new Pair((Object)"v", (Object)sound.stream1.volume));
                        details.add((Pair<String, Object>)new Pair((Object)"i", (Object)sound.stream1.index));
                        details.add((Pair<String, Object>)new Pair((Object)"p", (Object)sound.stream1.pitch));
                        details.add((Pair<String, Object>)new Pair((Object)"t", (Object)sound.stream1.ticksPlayed));
                        details.add((Pair<String, Object>)new Pair((Object)"d", (Object)sound.stream1.duration));
                        text = "[" + this.format(details) + "]";
                        details.clear();
                    }
                    if (sound.stream2 != null) {
                        details.add((Pair<String, Object>)new Pair((Object)"n", (Object)sound.stream2.location));
                        details.add((Pair<String, Object>)new Pair((Object)"v", (Object)sound.stream2.volume));
                        details.add((Pair<String, Object>)new Pair((Object)"i", (Object)sound.stream2.index));
                        details.add((Pair<String, Object>)new Pair((Object)"p", (Object)sound.stream2.pitch));
                        details.add((Pair<String, Object>)new Pair((Object)"t", (Object)sound.stream2.ticksPlayed));
                        details.add((Pair<String, Object>)new Pair((Object)"d", (Object)sound.stream2.duration));
                        text = (String)text + "[" + this.format(details) + "]";
                        details.clear();
                    }
                    list.add((String)text);
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                String s = (String)list.get(i);
                if (Strings.isNullOrEmpty((String)s)) continue;
                Objects.requireNonNull(AmbientTickHandler.mc.f_91062_);
                int j = 9;
                int k = AmbientTickHandler.mc.f_91062_.m_92895_(s);
                int i1 = 2 + j * i;
                PoseStack mat = new PoseStack();
                AmbientTickHandler.drawGradientRect(mat.m_85850_().m_85861_(), 0, 1, i1 - 1, 2 + k + 1, i1 + j - 1, -1873784752, -1873784752);
                AmbientTickHandler.mc.f_91062_.m_92750_(mat, s, 2.0f, (float)i1, 0xE0E0E0);
            }
        }
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(mat, (float)right, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_85982_(mat, (float)left, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_85982_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        buffer.m_85982_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public void loadLevel(LevelAccessor level) {
        if (level.m_5776_() && this.engine != null) {
            this.engine.onClientLoad();
        }
    }

    public void onTick() {
        if (this.soundEngine == null) {
            this.soundEngine = new AmbientSoundEngine(mc.m_91106_(), AmbientTickHandler.mc.f_91066_);
            if (this.engine == null) {
                this.setEngine(AmbientEngine.loadAmbientEngine(this.soundEngine));
            }
            if (this.engine != null) {
                this.engine.soundEngine = this.soundEngine;
            }
        }
        if (this.engine == null) {
            return;
        }
        ClientLevel level = AmbientTickHandler.mc.f_91073_;
        LocalPlayer player = AmbientTickHandler.mc.f_91074_;
        if (level != null && player != null && !mc.m_91104_() && AmbientTickHandler.mc.f_91066_.m_92147_(SoundSource.AMBIENT) > 0.0f) {
            AmbientDimension newDimension;
            if (this.enviroment == null) {
                this.enviroment = new AmbientEnviroment();
            }
            if (this.enviroment.dimension != (newDimension = this.engine.getDimension((Level)level))) {
                this.engine.changeDimension(this.enviroment, newDimension);
                this.enviroment.dimension = newDimension;
            }
            if (this.timer % this.engine.enviromentTickTime == 0) {
                this.enviroment.analyzeSlow(newDimension, this.engine, (Player)player, (Level)level, this.timer);
            }
            if (this.timer % this.engine.soundTickTime == 0) {
                this.enviroment.analyzeFast(newDimension, (Player)player, (Level)level, mc.m_91297_());
                this.engine.tick(this.enviroment);
                this.enviroment.dimension.manipulateEnviroment(this.enviroment);
            }
            this.engine.fastTick(this.enviroment);
            ++this.timer;
        } else if (!this.engine.activeRegions.isEmpty()) {
            this.engine.stopEngine();
        }
    }
}

