/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import java.util.Objects;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.gui.screen.HomeScreen;
import mcp.mobius.waila.hud.TooltipHandler;
import mcp.mobius.waila.network.Packets;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="waila", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeWailaClient
extends WailaClient {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        Packets.initClient();
        ForgeWailaClient.registerKeyBinds();
        ForgeWailaClient.registerConfigScreen();
    }

    static void registerConfigScreen() {
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, screen) -> new HomeScreen((Screen)screen)));
    }

    @Mod(value="wthit")
    @Mod.EventBusSubscriber(modid="wthit", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class HahaBorgeGoBrrrr {
        @SubscribeEvent
        static void clientSetup(FMLClientSetupEvent event) {
            ForgeWailaClient.registerConfigScreen();
        }
    }

    @Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
    static class Subscriber {
        Subscriber() {
        }

        @SubscribeEvent
        static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                TooltipHandler.render(event.getMatrixStack(), event.getPartialTicks());
            }
        }

        @SubscribeEvent
        static void clientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ForgeWailaClient.onClientTick();
            }
        }

        @SubscribeEvent
        static void itemTooltip(ItemTooltipEvent event) {
            ForgeWailaClient.onItemTooltip(event.getItemStack(), event.getToolTip());
        }

        @SubscribeEvent
        static void loggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
            ForgeWailaClient.onServerLogIn(Objects.requireNonNull(event.getConnection()));
        }
    }
}

