/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigScreen
extends Screen {
    private final Screen parent;
    private final Runnable saver;
    private final Runnable canceller;
    private final List<GuiEventListener> children = this.m_6702_();
    private ConfigListWidget options;

    public ConfigScreen(Screen parent, Component title, Runnable saver, Runnable canceller) {
        super(title);
        this.parent = parent;
        this.saver = saver;
        this.canceller = canceller;
    }

    public ConfigScreen(Screen parent, Component title) {
        this(parent, title, null, null);
    }

    public void m_7856_() {
        super.m_7856_();
        this.options = this.getOptions();
        this.children.add((GuiEventListener)this.options);
        this.m_7522_((GuiEventListener)this.options);
        if (this.saver != null && this.canceller != null) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 102, this.f_96544_ - 25, 100, 20, (Component)new TranslatableComponent("gui.done"), w -> {
                this.options.save();
                this.saver.run();
                this.m_7379_();
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 2, this.f_96544_ - 25, 100, 20, (Component)new TranslatableComponent("gui.cancel"), w -> {
                this.canceller.run();
                this.m_7379_();
            }));
        } else {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 25, 100, 20, (Component)new TranslatableComponent("gui.done"), w -> {
                this.options.save();
                this.m_7379_();
            }));
        }
    }

    public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrices);
        this.options.m_6305_(matrices, mouseX, mouseY, partialTicks);
        ConfigScreen.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)12, (int)0xFFFFFF);
        super.m_6305_(matrices, mouseX, mouseY, partialTicks);
        if (mouseY < 32 || mouseY > this.f_96544_ - 32) {
            return;
        }
        this.options.m_94729_(mouseX, mouseY).ifPresent(element -> {
            if (element instanceof ConfigValue) {
                ConfigValue value = (ConfigValue)((Object)element);
                boolean hasDescTl = I18n.m_118936_((String)value.getDescription());
                if (value.serverOnly || hasDescTl) {
                    String title = value.getTitle().getString();
                    ArrayList tooltip = Lists.newArrayList((Object[])new FormattedCharSequence[]{new TextComponent(title).m_7532_()});
                    if (hasDescTl) {
                        tooltip.addAll(this.f_96547_.m_92923_((FormattedText)new TranslatableComponent(value.getDescription()).m_130940_(ChatFormatting.GRAY), 250));
                    }
                    if (value.serverOnly) {
                        tooltip.addAll(this.f_96547_.m_92923_((FormattedText)new TranslatableComponent("config.waila.server_only").m_130940_(ChatFormatting.RED), 250));
                    }
                    this.m_96617_(matrices, tooltip, mouseX, mouseY);
                }
            }
        });
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public void addListener(GuiEventListener listener) {
        this.children.add(listener);
    }

    public abstract ConfigListWidget getOptions();
}

