/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.gson.Gson;
import io.netty.buffer.Unpooled;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.C2SPacketReceiver;
import lol.bai.badpackets.api.S2CPacketReceiver;
import lol.bai.badpackets.api.event.PacketSenderReadyCallback;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataAccessor;
import mcp.mobius.waila.access.ServerAccessor;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.registry.Registrar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Packets {
    public static final ResourceLocation VERSION = Waila.id("version");
    public static final ResourceLocation ENTITY = Waila.id("entity");
    public static final ResourceLocation BLOCK = Waila.id("block");
    public static final ResourceLocation DATA = Waila.id("data");
    public static final ResourceLocation CONFIG = Waila.id("config");
    public static final ResourceLocation BLACKLIST = Waila.id("blacklist");
    public static final ResourceLocation GENERATE_CLIENT_DUMP = Waila.id("generate_client_dump");
    private static final Gson GSON = new Gson();

    public static void initServer() {
        PacketSenderReadyCallback.registerServer((handler, sender, server) -> {
            FriendlyByteBuf versionBuf = new FriendlyByteBuf(Unpooled.buffer());
            versionBuf.m_130130_(4);
            sender.send(VERSION, versionBuf);
            FriendlyByteBuf blacklistBuf = new FriendlyByteBuf(Unpooled.buffer());
            BlacklistConfig blacklistConfig = Waila.BLACKLIST_CONFIG.get();
            Packets.writeIds(blacklistBuf, blacklistConfig.blockIds);
            Packets.writeIds(blacklistBuf, blacklistConfig.blockEntityTypeIds);
            Packets.writeIds(blacklistBuf, blacklistConfig.entityTypeIds);
            sender.send(BLACKLIST, blacklistBuf);
            FriendlyByteBuf configBuf = new FriendlyByteBuf(Unpooled.buffer());
            Map<String, List<ConfigEntry>> groups = PluginConfig.INSTANCE.getSyncableConfigs().stream().collect(Collectors.groupingBy(c -> c.getId().m_135827_()));
            configBuf.m_130130_(groups.size());
            groups.forEach((namespace, entries) -> {
                configBuf.m_130070_(namespace);
                configBuf.m_130130_(entries.size());
                entries.forEach(e -> {
                    configBuf.m_130070_(e.getId().m_135815_());
                    Object v = e.getValue();
                    if (v instanceof Boolean) {
                        Boolean z = (Boolean)v;
                        configBuf.writeByte(0);
                        configBuf.writeBoolean(z.booleanValue());
                    } else if (v instanceof Integer) {
                        Integer i = (Integer)v;
                        configBuf.writeByte(1);
                        configBuf.m_130130_(i.intValue());
                    } else if (v instanceof Double) {
                        Double d = (Double)v;
                        configBuf.writeByte(2);
                        configBuf.writeDouble(d.doubleValue());
                    } else if (v instanceof String) {
                        String str = (String)v;
                        configBuf.writeByte(3);
                        configBuf.m_130070_(str);
                    } else if (v instanceof Enum) {
                        Enum en = (Enum)v;
                        configBuf.writeByte(3);
                        configBuf.m_130070_(en.name());
                    }
                });
            });
            sender.send(CONFIG, configBuf);
        });
        C2SPacketReceiver.register((ResourceLocation)VERSION, (server, player, handler, buf, responseSender) -> {
            int clientVersion = buf.m_130242_();
            if (clientVersion != 4) {
                handler.m_9942_((Component)new TextComponent("WTHIT network version mismatch! Server version is 4 while client version is " + clientVersion));
            }
        });
        C2SPacketReceiver.register((ResourceLocation)ENTITY, (server, player, handler, buf, responseSender) -> {
            int entityId = buf.m_130242_();
            Vec3 hitPos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            server.execute(() -> {
                Registrar registrar = Registrar.INSTANCE;
                Level world = player.f_19853_;
                Entity entity = world.m_6815_(entityId);
                if (entity == null) {
                    return;
                }
                CompoundTag data = new CompoundTag();
                IServerAccessor accessor = ServerAccessor.INSTANCE.set(world, player, (HitResult)new EntityHitResult(entity, hitPos), entity);
                for (IServerDataProvider<Entity> provider : registrar.entityData.get(entity)) {
                    provider.appendServerData(data, accessor, PluginConfig.INSTANCE);
                    provider.appendServerData(data, player, world, entity);
                }
                data.m_128405_("WailaEntityID", entity.m_142049_());
                FriendlyByteBuf dataBuf = new FriendlyByteBuf(Unpooled.buffer());
                dataBuf.m_130079_(data);
                responseSender.send(DATA, dataBuf);
            });
        });
        C2SPacketReceiver.register((ResourceLocation)BLOCK, (server, player, handler, buf, responseSender) -> {
            BlockHitResult hitResult = buf.m_130283_();
            server.execute(() -> {
                Registrar registrar = Registrar.INSTANCE;
                Level world = player.f_19853_;
                BlockPos pos = hitResult.m_82425_();
                if (!world.m_46805_(pos)) {
                    return;
                }
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity == null) {
                    return;
                }
                BlockState state = world.m_8055_(pos);
                CompoundTag data = new CompoundTag();
                IServerAccessor accessor = ServerAccessor.INSTANCE.set(world, player, (HitResult)hitResult, blockEntity);
                for (IServerDataProvider<BlockEntity> provider : registrar.blockData.get(blockEntity)) {
                    provider.appendServerData(data, accessor, PluginConfig.INSTANCE);
                    provider.appendServerData(data, player, world, blockEntity);
                }
                for (IServerDataProvider<BlockEntity> provider : registrar.blockData.get(state.m_60734_())) {
                    provider.appendServerData(data, accessor, PluginConfig.INSTANCE);
                    provider.appendServerData(data, player, world, blockEntity);
                }
                data.m_128405_("x", pos.m_123341_());
                data.m_128405_("y", pos.m_123342_());
                data.m_128405_("z", pos.m_123343_());
                data.m_128359_("id", Registry.f_122830_.m_7981_((Object)blockEntity.m_58903_()).toString());
                FriendlyByteBuf dataBuf = new FriendlyByteBuf(Unpooled.buffer());
                dataBuf.m_130079_(data);
                responseSender.send(DATA, dataBuf);
            });
        });
    }

    public static void initClient() {
        PacketSenderReadyCallback.registerClient((handler, sender, client) -> {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130130_(4);
            sender.send(VERSION, buf);
        });
        S2CPacketReceiver.register((ResourceLocation)VERSION, (client, handler, buf, responseSender) -> {
            int serverVersion = buf.m_130242_();
            if (serverVersion != 4) {
                handler.m_6198_().m_129507_((Component)new TextComponent("WTHIT network version mismatch! Server version is " + serverVersion + " while client version is 4"));
            }
        });
        S2CPacketReceiver.register((ResourceLocation)DATA, (client, handler, buf, responseSender) -> {
            CompoundTag data = buf.m_130260_();
            client.execute(() -> DataAccessor.INSTANCE.setServerData(data));
        });
        S2CPacketReceiver.register((ResourceLocation)CONFIG, (client, handler, buf, responseSender) -> {
            HashMap<ResourceLocation, Object> map = new HashMap<ResourceLocation, Object>();
            int groupSize = buf.m_130242_();
            for (int i = 0; i < groupSize; ++i) {
                String namespace = buf.m_130277_();
                int groupLen = buf.m_130242_();
                block7: for (int j = 0; j < groupLen; ++j) {
                    ResourceLocation id = new ResourceLocation(namespace, buf.m_130277_());
                    byte type = buf.readByte();
                    switch (type) {
                        case 0: {
                            map.put(id, buf.readBoolean());
                            continue block7;
                        }
                        case 1: {
                            map.put(id, buf.m_130242_());
                            continue block7;
                        }
                        case 2: {
                            map.put(id, buf.readDouble());
                            continue block7;
                        }
                        case 3: {
                            map.put(id, buf.m_130277_());
                        }
                    }
                }
            }
            client.execute(() -> {
                for (ConfigEntry<Object> config : PluginConfig.INSTANCE.getSyncableConfigs()) {
                    Object syncedValue;
                    ResourceLocation id = config.getId();
                    Object clientOnlyValue = config.getClientOnlyValue();
                    if (clientOnlyValue instanceof Enum) {
                        Enum e = (Enum)clientOnlyValue;
                        v0 = Enum.valueOf(e.getDeclaringClass(), map.getOrDefault(id, e.name()));
                    } else {
                        v0 = syncedValue = map.getOrDefault(id, clientOnlyValue);
                    }
                    if (syncedValue instanceof Double) {
                        Double d = (Double)syncedValue;
                        if (clientOnlyValue instanceof Integer) {
                            syncedValue = d.intValue();
                        }
                    }
                    config.setValue(syncedValue);
                }
                Waila.LOGGER.info("Received config from the server: {}", (Object)GSON.toJson((Object)map));
            });
        });
        S2CPacketReceiver.register((ResourceLocation)BLACKLIST, (client, handler, buf, responseSender) -> {
            Set<ResourceLocation> blockIds = Packets.readIds(buf);
            Set<ResourceLocation> blockEntityIds = Packets.readIds(buf);
            Set<ResourceLocation> entityIds = Packets.readIds(buf);
            client.execute(() -> {
                BlacklistConfig blacklist = Waila.BLACKLIST_CONFIG.get();
                Packets.setBlackList(blockIds, blacklist.blocks, Registry.f_122824_);
                Packets.setBlackList(blockEntityIds, blacklist.blockEntityTypes, Registry.f_122830_);
                Packets.setBlackList(entityIds, blacklist.entityTypes, Registry.f_122826_);
            });
        });
        S2CPacketReceiver.register((ResourceLocation)GENERATE_CLIENT_DUMP, (client, handler, buf, responseSender) -> client.execute(() -> {
            Path path = Waila.GAME_DIR.resolve(".waila/WailaClientDump.md");
            if (DumpGenerator.generate(path) && client.f_91074_ != null) {
                client.f_91074_.m_5661_((Component)new TranslatableComponent("command.waila.client_dump_success", new Object[]{path}), false);
            }
        }));
    }

    private static <T> void setBlackList(Set<ResourceLocation> ids, Set<T> set, Registry<T> registry) {
        for (ResourceLocation id : ids) {
            set.add(registry.m_7745_(id));
        }
    }

    private static void writeIds(FriendlyByteBuf buf, Set<ResourceLocation> set) {
        Map<String, List<ResourceLocation>> groups = set.stream().collect(Collectors.groupingBy(ResourceLocation::m_135827_));
        buf.m_130130_(groups.size());
        groups.forEach((namespace, ids) -> {
            buf.m_130070_(namespace);
            buf.m_130130_(ids.size());
            ids.forEach(id -> buf.m_130070_(id.m_135815_()));
        });
    }

    private static Set<ResourceLocation> readIds(FriendlyByteBuf buf) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        int groupSize = buf.m_130242_();
        for (int i = 0; i < groupSize; ++i) {
            String namespace = buf.m_130277_();
            int groupLen = buf.m_130242_();
            for (int j = 0; j < groupLen; ++j) {
                set.add(new ResourceLocation(namespace, buf.m_130277_()));
            }
        }
        return set;
    }
}

